<?php

$themepath = $multipath."themes/".$thename."/";
$imgpath = $themepath."images/";

//Define username if logged in or anonymous if not
cookiedecode($user);
$username = $cookie[1];

if ($username == "") {
    $username = _ANONYMOUS;
    $loggedin = false;
} else {
    $loggedin = true;
}
//Define custom templates, colors, image and block display for modules
if($custom_module) {
    foreach($custom_module as $name => $innerarray) {
        if($module_name == $name) {
            //Override main template file names
            foreach($template as $key => $new) {
                if(isset($innerarray[$key])) {
                    $newval[$key] = $innerarray[$key];
                } else {
                    $newval[$key] = $new;
                }
            }
            if($newval) {
                $template = $newval;
                unset($newval);
            }
            //Override default block display
            foreach($block_display as $key => $new) {
                if(isset($innerarray[$key])) {
                    $newval[$key] = $innerarray[$key];
                } else {
                    $newval[$key] = $new;
                }
            }
            if($newval) {
                $block_display = $newval;
                unset($newval);
            }
            //Override style sheet, logo image and colors
            foreach($miscellaneous as $key => $new) {
                if(isset($innerarray[$key])) {
                    $newval[$key] = $innerarray[$key];
                } else {
                    $newval[$key] = $new;
                }
            }
            if($newval) {
                $miscellaneous = $newval;
                unset($newval);
            }
        }
    }
}
//Assign some settings to vars to be used for commands and by modules
$stylesheet = $miscellaneous['stylesheet'];
$logoimg = $miscellaneous['logo'];
$bgcolor1 = $miscellaneous['bgcolor1'];
$bgcolor2 = $miscellaneous['bgcolor2'];
$bgcolor3 = $miscellaneous['bgcolor3'];
$bgcolor4 = $miscellaneous['bgcolor4'];
$textcolor1 = $miscellaneous['textcolor1'];
$textcolor1 = $miscellaneous['textcolor2'];

//Load theme templates into strings
foreach($template as $name => $file) {
    $HTML[$name] = atTemplateLoad($themepath.$file);
}
//Prepare main page and header and footer
//Strip from begining to head or head close
if($strip_head) {
    $HTML['main'] = strip_to($HTML['main'], "/HEAD", null, 0);
} else {
    $HTML['main'] = strip_to($HTML['main'], "HEAD", null, 1);
}
//Strip from body close to end
$HTML['main'] = strip_from($HTML['main'], "/BODY", null, 1);

//Split into themeheader and themefooter
list ($HTML['header'], $HTML['footer']) = split_it($HTML['main'], null, "[modules]");
unset($template, $HTML['main']);

//Break apart on comments, find commands in comments and remove comments
foreach($HTML as $name => $stuff) {
    list ($output[$name], $commands[$name]) = find_commands($stuff, $command);
}
unset($HTML);

//Add custom style sheet
if ($stylesheet && file_exists($themepath."style/".$stylesheet)) {
    $output['header'][0] = "<link rel=\"StyleSheet\" href=\"".$themepath."style/".$stylesheet."\" type=\"text/css\" />\n".$output['header'][0];
}
//Add style for languages that read right-to-left
if ($currentlang == "arabic" || $currentlang == "hebrew") {
    $output['header'][0] = "<style type=\"text/css\">body { direction: rtl; text-align: right }</style>\n".$output['header'][0];
}
//Finish Up
$output['header'][0] = "\n\n<!-- Begin AutoTheme Content -->\n\n".$output['header'][0];
$output['footer'][count($output['footer'])-1] = $output['footer'][count($output['footer'])-1]."\n<!-- End AutoTheme Content -->\n\n";

$all_vars = get_defined_vars();

//Functions
//
//Calculate position after end of last comment (start)
//position at beginning of current comment (cstart) *not needed here*
//position at end of current comment (end)
function find_commands($tmpcontent, $tmpcmds)
{
    $i = 0;
    $pos = 0;
    $start[0] = 0;
    while(find_any_comment($tmpcontent, $pos) !== false) {
        list($cstart, $end[$i]) = find_any_comment($tmpcontent, $pos);
        $pos = $end[$i];
        $i++;
        $start[$i] = $end[$i - 1] + 1;
    }
    $end[$i] = strlen($tmpcontent);
    //Use start and end positions to assign theme parts to array
    $i = 0;
    while($i != count($start)) {
        $newcontent[$i] = substr($tmpcontent, $start[$i], ($end[$i] - $start[$i] + 1));
        $i++;
    }
    $tmpcontent = $newcontent;
    unset($newcontent);
    //Find commands in comments and assign to array and remove comments
    $i = 0;
    while($i != count($tmpcontent)) {
    foreach($tmpcmds as $name => $cmds) {
        if(stristr($tmpcontent[$i], $name)) {
            $commands[$i] = $name;
        }
    }
    list($cstart, $cend) = find_any_comment($tmpcontent[$i], 0);
    if($cstart) {
        $newcontent[$i] = substr($tmpcontent[$i], 0, $cstart);
    } else {
        $newcontent[$i] = $tmpcontent[$i]; }
    $i++;
    }
    return array($newcontent, $commands);
}

//Find and return list of start and end positions of a tag
//tag string of form "HTML" or "/HTML"
function find_tag($tmpcontent, $tag)
{
    $temp = stristr($tmpcontent, "<".$tag);
    $pos = strlen($tmpcontent) - strlen($temp);
    if($pos) {
        $start = $pos;
        $end = strpos($tmpcontent, ">", $start);
        return array($start, $end);
    } else {
        return false;
    }
}

//Find and return list of start and end positions of a comment
//comment string of form "THIS IS A COMMENT"
function find_comment($tmpcontent, $comment)
{
    while(strpos($tmpcontent, "<!-", $end)) {
        $start = strpos($tmpcontent, "<!-", $end);
        $end = strpos($tmpcontent, "->", $start) + 1;
        $tmpstr = substr($tmpcontent, $start, $end - $start);
        if(stristr($tmpstr, $comment)) {
            return array($start, $end);
        }
    }
    return false;
}

//Find and return list of start and end position of next comment
//pos is position in string to start from
function find_any_comment($tmpcontent, $pos)
{
    $start = strpos($tmpcontent, "<!-", $pos);
    if(!is_bool($start)) {
        $end = strpos($tmpcontent, "->", $start) + 1;
        return array($start, $end);
    }
    return false;
}

//Split at tag or comment
//tag string of form "HTML" or "/HTML"
//comment string of form "THIS IS A COMMENT"
function split_it($tmpcontent, $tag, $comment)
{
    $first = strip_from($tmpcontent, $tag, $comment, 0);
    $last = strip_to($tmpcontent, $tag, $comment, 1);
    return array($first, $last);
}

//Truncate from tag or comment to end of string
//tag string of form "HTML" or "/HTML"
//comment string of form "THIS IS A COMMENT"
//inc boolean whether to strip the tag its self strip=1
function strip_from($tmpcontent, $tag, $comment, $inc)
{
    if($tag) { //tag was passed
        list ($start, $end) = find_tag($tmpcontent, $tag);
    }
    elseif($comment) { //comment was passed
        list ($start, $end) = find_comment($tmpcontent, $comment);
    }
    if($inc) {
        $len = $start;
    } else {
        $len = $end + 1;
    }
    $newcontent = substr($tmpcontent, 0, $len);
    return $newcontent;
}

//Truncate from begining of string up to tag or comment
//tag string of form "HTML" or "/HTML"
//comment string of form "THIS IS A COMMENT"
//inc boolean whether to strip the tag its self strip=1
function strip_to($tmpcontent, $tag, $comment, $inc)
{
    if($tag) { //tag was passed
        list ($start, $end) = find_tag($tmpcontent, $tag);
    }
    elseif($comment) { //comment was passed
        list ($start, $end) = find_comment($tmpcontent, $comment);
    }
    if($inc) {
        $len = $end + 1;
    } else {
        $len = $start;
    }
    $newcontent = substr($tmpcontent, $len, strlen($tmpcontent) - $len);
    return $newcontent;
}

//Load file contents into string
function atTemplateLoad($filename)
{
	$fp = @fopen($filename, "r");
	if (!($fp)) {
		return 0;
    }
	while (!feof($fp)) {
		$temp .= fread($fp, 4096);
    }
    return $temp;
}

//Echo parts and execute commands
function display_parts($tmpparts, $tmpcmds)
{
    global $all_vars;
    extract($all_vars);

    $i = 0;
    while($i != count($tmpparts)) {
        $tmpcontent = "?>".$tmpparts[$i];
        eval($tmpcontent);
        foreach($command as $name => $cmds) {
            if($tmpcmds[$i] == $name) {
                $docmd = $cmds;
                eval($docmd);
            }
        }
        $i++;
    }
}

?>
