<?php

global $all_vars, $index;
global $language, $currentlang, $module_name, $anonymous, $admin, $sid, $slogan, $sitename;

$autotheme_theme = true;
$thename = basename(dirname(__FILE__));

//Include theme specific files for config, command definition, parsing and functions
include(dirname(__FILE__)."/theme.cfg");

//Load theme language file
if(file_exists("themes/$thename/language/lang-$currentlang.php")) {
    include("themes/$thename/language/lang-$currentlang.php");
}
elseif(file_exists("themes/$thename/language/lang-$language.php")) {
    include("themes/$thename/language/lang-$language.php");
}
include(dirname(__FILE__)."/includes/commands.inc.php");
include(dirname(__FILE__)."/includes/autotheme.inc.php");

//Tables that modules and others call so as to keep consistent with the theme
function OpenTable()
{
    global $bgcolor1, $bgcolor2;
    echo "<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"0\" bgcolor=\"$bgcolor2\"><tr><td>\n";
    echo "<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"8\" bgcolor=\"$bgcolor1\"><tr><td>\n";
}

function CloseTable()
{
    echo "</td></tr></table></td></tr></table>\n";
}

function OpenTable2()
{
    global $bgcolor1, $bgcolor2;
    echo "<table border=\"0\" cellspacing=\"1\" cellpadding=\"0\" bgcolor=\"$bgcolor2\" align=\"center\"><tr><td>\n";
    echo "<table border=\"0\" cellspacing=\"1\" cellpadding=\"8\" bgcolor=\"$bgcolor1\"><tr><td>\n";
}

function CloseTable2()
{
    echo "</td></tr></table></td></tr></table>\n";
}

//This is the theme header - the layout that is rendered before the modules
function themeheader()
{
    global $all_vars;
    extract($all_vars);
    display_parts($output['header'], $commands['header']);
}

//This is the theme footer - the layout that is rendered after the modules
function themefooter()
{
    global $all_vars;
    extract($all_vars);
    display_parts($output['footer'], $commands['footer']);
}

//This displays the article summary on the main page
function themeindex ($aid, $informant, $datetime, $title, $counter, $topic, $bodytext, $notes, $morelink, $topicname, $topicimage, $topictext)
{
    global $all_vars;
    extract($all_vars, EXTR_SKIP);
    //$all_vars = get_defined_vars();

    $summary_count ++;

    if($alternate_summary) {
        if($summary_count % 2 == 0) {
            $sparts = $output['summary1'];
            $scommands = $commands['summary1'];
        } else {
            $sparts = $output['summary2'];
            $scommands = $commands['summary2'];
        }
    } else {
        $sparts = $output['summary'];
        $scommands = $commands['summary'];
    }

    $all_vars = get_defined_vars();
    display_parts($sparts, $scommands);
    //display_parts($output['summary'], $commands['summary']);
}

//This displays the full article when read more... is clicked in the article summary
function themearticle ($aid, $informant, $datetime, $title, $bodytext, $topic, $topicname, $topicimage, $topictext)
{
    global $all_vars;
    extract($all_vars, EXTR_SKIP);
    $all_vars = get_defined_vars();
    display_parts($output['article'], $commands['article']);
}

//These are the side blocks
function themesidebox($title, $content)
{
    global $all_vars;
    extract($all_vars, EXTR_SKIP);

    $bparts = $output['block'];
    $bcommands = $commands['block'];

    //Define custom block templates
    $title = trim(strip_tags($title, ""));

    if($custom_block) {
        foreach($custom_block as $name => $file) {
            if($name == $title && file_exists($themepath.$file)) {
                $HTML = atTemplateLoad($themepath.$file);
                list ($bparts, $bcommands) = find_commands($HTML, $command);
            }
        }
    }

    //Echo parts and execute commands
    if($bparts) {
        $all_vars = get_defined_vars();
        display_parts($bparts, $bcommands);
    }
}

?>
