<?php

/************************************************************************************/
/*                                                                                  */
/* Maty Scripts Top-Sites for PHP-Nuke 6.5                                          */
/* v1.0  25-03-2003                                                                 */
/*                                                                                  */
/* Copyright  2002 by: Maty Scripts (webmaster@matyscripts.com)                    */
/* http://www.matyscripts.com                                                       */
/*                                                                                  */
/* This program is free software. You can redistribute it and/or modify             */
/* it under the terms of the GNU General Public License as published by             */
/* the Free Software Foundation; either version 2 of the License.                   */
/*                                                                                  */
/************************************************************************************/

$index = 1;
$module_name = basename( dirname( __FILE__ ) );

if (!eregi("modules.php", $_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

if( isset( $newlang ) ) {
   include( "modules/$module_name/language/lang-$newlang.php" );
   $language = $newlang;
} elseif ( isset( $lang ) ) {
   include( "modules/$module_name/language/lang-$lang.php" );
   $language = $lang;
} else {
   include( "modules/$module_name/language/lang-$language.php" );
}

require_once( "mainfile.php" );
require_once( "modules/$module_name/class.mstopsites.php" );
/******************************************************************************/
/* FUNCTION: MSTopSitesEdit()                                                 */
/* A Member wants to edit his/her Settings                                    */
/******************************************************************************/
function MSTopSitesEdit( )
{
   $msts = new mstopsites();

   include( "header.php" );
   // Plot Header
   $msts->MSTopSitesPlotHeader();
   // Plot Menu
   echo "".$msts->MSTopSitesPlotMenu();

   $tuser = $msts->MSTopSitesTypeOfUser();  // 0 = Guest - 1 = Site Member - 2 = Site + Top-Site member | uname | memberid
   $tuser = explode( "|",$tuser );
   if( $tuser[ 0 ] == 2 ) { MSTopSitesEditSite( $tuser[ 1 ] ); }
   else {
      if( $tuser[ 0 ] == 1 ) { $message = "Hi <font color=\"#FF0000\">".$tuser[ 1 ]."</font>, "._MSTS_ADDSITEFIRST; } else { $message = _MSTS_NOTREGISTERED; }
      echo "".$msts->MSTopSitesMessageScreen( _MSTS_EDITSITE, $message );
   }
   // Plot footer    
   $msts->MSTopSitesPlotFooter();   
   include( "footer.php" );
}

/******************************************************************************/
/* FUNCTION: MSTopSitesEditSite()                                             */
/* A Member wants to edit his/her Settings                                    */
/******************************************************************************/
function MSTopSitesEditSite( $uname )
{
   global $module_name, $db, $prefix, $bgcolor1, $bgcolor2;
   $msts = new mstopsites();

   $result = $db->sql_query( "SELECT sitename, url, buttonurl, email, description, category FROM $prefix"._mstopsites." WHERE uname = '$uname'" );
   list( $sname, $url, $buttonurl, $email, $description, $category ) = $db->sql_fetchrow( $result );  
   $result1 = $db->sql_query( "SELECT webmaster_email, categories FROM $prefix"._mstopsites_cnf." WHERE id = '1'" );
   list( $webmaster_email, $categories ) = $db->sql_fetchrow( $result1 );
   $ecategories = explode( '|', $categories );

   echo "<center>\n";
   echo "<form action=\"modules.php?name=$module_name&file=edit\" method=\"post\">\n";
   echo "<table border=\"1\" cellpadding=\"2\" cellspacing=\"0\" width=\"90%\" bgcolor=$bgcolor2 class=\"content\">\n";
   echo "<tr class=\"title\">\n";
   echo "<td width=\"100%\" colspan=\"2\" bgcolor=$bgcolor2>\n";
   echo "<p align=\"center\">< "._MSTS_EDITSITE." ?></td>\n";
   echo "</tr>\n";
   echo "<tr>\n";
   echo "<td width=\"50%\" bgcolor=$bgcolor1>"._MSTS_USERNAME."</td>\n";
   echo "<td width=\"50%\" bgcolor=$bgcolor1><font color=\"#FF0000\">$uname</font></td>\n";
   echo "</tr>\n";   
   echo "<tr>\n";
   echo "<td width=\"50%\" bgcolor=$bgcolor1>"._MSTS_SITENAME."</td>\n";
   echo "<td width=\"50%\" bgcolor=$bgcolor1><input type=\"text\" name=\"sname\" value=\"".htmlspecialchars($sname)."\" size=\"50\"></td>\n";
   echo "</tr>\n";
   echo "<tr>\n";
   echo "<td width=\"50%\" bgcolor=$bgcolor1>"._MSTS_URL."<br> (e.g. http://www.yoursite.com)</td>\n";
   echo "<td width=\"50%\" bgcolor=$bgcolor1><input type=\"text\" name=\"url\" value=\"".htmlspecialchars($url)."\" size=\"50\"></td>\n";
   echo "</tr>\n";
   echo "<tr>\n";
   echo "<td width=\"50%\" bgcolor=$bgcolor1>"._MSTS_EMAIL."<br> (e.g. your-email@site.com)</td>\n";
   echo "<td width=\"50%\" bgcolor=$bgcolor1><input type=\"text\" name=\"email\" value=\"".htmlspecialchars($email)."\" size=\"50\"></td>\n";
   echo "</tr>\n";   
   echo "<tr>\n";
   echo "<td width=\"50%\" bgcolor=$bgcolor1>"._MSTS_BUTTON."<br> (e.g. http://www.yoursite.com/yourbutton.gif)</td>\n";
   echo "<td width=\"50%\" bgcolor=$bgcolor1><input type=\"text\" name=\"buttonurl\" value=\"".htmlspecialchars($buttonurl)."\" size=\"50\"></td>\n";
   echo "</tr>\n";
   echo "<tr>\n";
   echo "<td width=\"50%\" valign=\"top\" bgcolor=$bgcolor1>"._MSTS_CATEGORY."<br><br>"._MSTS_CATEGORYMISSING.": $webmaster_email</td>\n";
   // Show various categories
   echo "<td width=\"50%\" bgcolor=$bgcolor1><select size=\"1\" name=\"cat\">\n";
   for( $i = 0; $i < sizeof( $ecategories ); $i++ ) { if( strcmp( $ecategories[ $i ], $category ) == 0 ) { echo "<option selected>".$ecategories[ $i ]."</option>\n"; } else { echo "<option>".$ecategories[ $i ]."</option>\n"; } }
   echo "</select></td>\n";
   echo "</tr>\n";
   echo "<tr>\n";
   echo "<td width=\"50%\" valign=\"top\" bgcolor=$bgcolor1>"._MSTS_DESCRIPTION."</td>\n";
   echo "<td width=\"50%\" bgcolor=$bgcolor1><textarea rows=\"7\" name=\"description\" cols=\"50\">".htmlspecialchars($description)."</textarea></td>\n";
   echo "</tr>\n";
   echo "<tr>\n";
   echo "<td width=\"100%\" valign=\"top\" colspan=\"2\" bgcolor=$bgcolor1>\n";
   echo "<input type=\"hidden\" name=\"uname\" value=\"$uname\">\n";
   echo "<input type=\"hidden\" name=\"op\" value=\"MSTopSitesSaveSite\">\n";
   echo "<p align=\"center\"><input type=\"submit\" value=\""._MSTS_SAVESITE."\"></td>\n";
   echo "</tr>\n";
   echo "</table>\n";
   echo "</form>\n";
   echo "</center>\n";
}

/******************************************************************************/
/* FUNCTION: MSTopSitesSaveSite()                                             */
/* Check if all apply settings are entered and then update Site               */
/******************************************************************************/
function MSTopSitesSaveSite( $uname, $sname, $url, $email, $buttonurl, $description, $cat )
{
   global $module_name, $db, $prefix, $bgcolor1, $bgcolor2;
   $msts = new mstopsites();

   include( "header.php" );
   // Plot Header
   $msts->MSTopSitesPlotHeader();
   // Plot Menu
   echo "".$msts->MSTopSitesPlotMenu();

   if( $uname == "" || $sname == "" || $url == "" || $email == "" || $description == "" ) {
      $msts->MSTopSitesMessageScreen( _MSTS_EDITSITE, _MSTS_ALLFIELDSREG );
   }
   else {
      $result = $db->sql_query( "update $prefix"._mstopsites." set sitename = '$sname', url = '$url', email = '$email', buttonurl = '$buttonurl', description = '$description', category = '$cat' where uname = '$uname'" );
      echo "<center><br>\n";
      echo "<table border=\"1\" cellpadding=\"2\" cellspacing=\"0\" width=\"50%\" bgcolor=$bgcolor2 class=\"content\">\n";
      echo "<tr class=\"title\">\n";
      echo "<td width=\"100%\" bgcolor=$bgcolor2><p align=\"center\">< "._MSTS_EDITSITE." ?></td>\n";
      echo "</tr>\n";
      echo "<tr>\n";
      echo "<td width=\"100%\" bgcolor=$bgcolor1>Hi <font color=\"#FF0000\">".$uname."</font>, "._MSTS_EDITSITEWELCOME."<br><br>\n";
      echo "<center><a href=\"modules.php?name=$module_name&file=index\">"._MSTS_MAIN."</a></center></td>\n";            
      echo "</tr>\n";
      echo "</table>\n";
      echo "</center>\n";      
   }
   
   // Plot footer
   $msts->MSTopSitesPlotFooter();
   include( "footer.php" );
}
/***************************************************/
/****************** PROGRAM START ******************/
/***************************************************/
switch ( $op )
{
    case "MSTopSitesEdit":
       MSTopSitesJoin( );
    break;

    case "MSTopSitesSaveSite":
       MSTopSitesSaveSite( $uname, $sname, $url, $email, $buttonurl, $description, $cat );
    break;

    default:
       MSTopSitesEdit( );
}


?>
