<?php

/************************************************************************************/
/*                                                                                  */
/* Maty Scripts Top-Sites for PHP-Nuke 6.5                                          */
/* v1.0  25-03-2003                                                                 */
/*                                                                                  */
/* Copyright  2002 by: Maty Scripts (webmaster@matyscripts.com)                    */
/* http://www.matyscripts.com                                                       */
/*                                                                                  */
/* This program is free software. You can redistribute it and/or modify             */
/* it under the terms of the GNU General Public License as published by             */
/* the Free Software Foundation; either version 2 of the License.                   */
/*                                                                                  */
/************************************************************************************/

$module_name = basename( dirname( __FILE__ ) );

if (!eregi("modules.php", $_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

if( isset( $newlang ) ) {
   include( "modules/$module_name/language/lang-$newlang.php" );
   $language = $newlang;
} elseif ( isset( $lang ) ) {
   include( "modules/$module_name/language/lang-$lang.php" );
   $language = $lang;
} else {
   include( "modules/$module_name/language/lang-$language.php" );
}

require_once( "mainfile.php" );
require_once( "modules/$module_name/class.mstopsites.php" );
/******************************************************************************/
/* FUNCTION: MSTopSitesIn()                                                   */
/* External Vote for a Site                                                   */
/******************************************************************************/
function MSTopSitesIn( $id )
{
   global $db, $prefix, $module_name;
   $msts = new mstopsites();
 
   // Plot Header
   $msts->MSTopSitesPlotHeader();

   $result = $db->sql_query( "SELECT sitename FROM $prefix"._mstopsites." WHERE memberid='$id'" );
   list( $sitename ) = $db->sql_fetchrow( $result );
   echo "<br><center>" . _MSTS_IN1 . " <b>" . $sitename . "</b></center>\n";
   echo "<center>" . _MSTS_IN2 . "</center>\n";
   
   echo "<br><center>\n";
   echo "<form action=\"modules.php?name=$module_name&file=in\" method=\"post\">\n";
   echo "<table border=\"0\" cellpadding=\"2\" cellspacing=\"0\" width=\"20%\" class=\"content\">\n";
   echo "<tr>\n";
   echo "<td width=\"50%\" align=\"right\">\n";
   echo "<select size=\"1\" name=\"msvote\">\n";
   for( $i = 1; $i < 11; $i++ ) {
      if( $i == 5 ) { echo "<option selected>$i</option>\n"; }
      else { echo "<option>$i</option>\n"; }
   }
   echo "</select>\n";
   echo "</td>\n";
   echo "<td width=\"50%\" align=\"left\">\n";
   echo "<input type=\"hidden\" name=\"id\" value=\"$id\">\n";   
   echo "<input type=\"hidden\" name=\"op\" value=\"MSTopSitesVoteIn\">\n";
   echo "<p align=\"center\"><input type=\"submit\" value=\""._MSTS_IN7."\">\n";
   echo "</td>\n";
   echo "</tr>\n";   
   echo "</table>\n";
   echo "</form>\n";
   echo "" . _MSTS_IN4 . ": 1=" . _MSTS_IN5 . "   10=" . _MSTS_IN6 . "\n";   
   echo "</center>\n";   
   
   echo "<br><center><b><a href=\"modules.php?name=$module_name&file=index&cpage=\">"._MSTS_IN3."</a></b></center>\n";
   
   // Plot footer    
   $msts->MSTopSitesPlotFooter();
    
} // END function MSTopSitesIn()


/******************************************************************************/
/* FUNCTION: MSTopSitesVoteIn()                                               */
/* Record made Vote and Rating                                                */
/******************************************************************************/
function MSTopSitesVoteIn( $id, $msvote )
{
   global $db, $prefix, $module_name;
   $msts = new mstopsites();

   if( $msts->MSTopSitesIPCheck( $id ) ) {
      $result = $db->sql_query( "SELECT memberid FROM $prefix"._mstopsites." WHERE memberid = '$id'" );
      if( $result )
      {
         $result = $db->sql_query( "SELECT startdate, curdate, hitstoday FROM $prefix"._mstopsites." WHERE memberid = '$id'" );
         list( $startdate, $curdate, $hitstoday ) = $db->sql_fetchrow( $result );

         $today    = date( "Y-m-d G:i:s" );
         $newdate  = $msts->MSTopSitesCDate( $today );
         $olddate  = $msts->MSTopSitesCDate( $curdate );   
   
         $a = "UPDATE $prefix"._mstopsites." SET hitsin = hitsin + 1, hitstotal = hitstotal + 1 WHERE memberid = '$id'";
         if( $newdate != $olddate ) { $b = "UPDATE $prefix"._mstopsites." SET hitstoday = 1, curdate = '$today' WHERE memberid = '$id'"; }
         else { $b = "UPDATE $prefix"._mstopsites." SET hitstoday = hitstoday + 1 WHERE memberid = '$id'"; }
      
         $daysold = $msts->MSTopSitesDaysOld( $startdate );
         $c = "UPDATE $prefix"._mstopsites." SET daysold = '$daysold' WHERE memberid = '$id'";

         // Update rating
         $d = "UPDATE $prefix"._mstopsites." SET rating = rating + $msvote WHERE memberid = '$id'";
      
         $db->sql_query( $a );
         $db->sql_query( $b );
         $db->sql_query( $c );
         $db->sql_query( $d );      
      }
   }   
   // Go To MS Top-Sites Main Page
   $result = $db->sql_query( "SELECT webmaster_url FROM $prefix"._mstopsites_cnf." WHERE id = '1'" );
   list( $webmaster_url ) = $db->sql_fetchrow( $result );    
   $url = "$webmaster_url/modules.php?name=$module_name&file=index";
   header( "Location: $url" );
}


/***************************************************/
/****************** PROGRAM START ******************/
/***************************************************/
switch ( $op )
{
    case "MSTopSitesIn":
       MSTopSitesIn( $id );
    break;
    
    case "MSTopSitesVoteIn":
       MSTopSitesVoteIn( $id, $msvote );
    break;    
    
    default:
       MSTopSitesIn( $id );
}


?>
