<?php

/************************************************************************************/
/*                                                                                  */
/* Maty Scripts Top-Sites for PHP-Nuke 6.5                                          */
/* v1.0  25-03-2003                                                                 */
/*                                                                                  */
/* Copyright  2002 by: Maty Scripts (webmaster@matyscripts.com)                    */
/* http://www.matyscripts.com                                                       */
/*                                                                                  */
/* This program is free software. You can redistribute it and/or modify             */
/* it under the terms of the GNU General Public License as published by             */
/* the Free Software Foundation; either version 2 of the License.                   */
/*                                                                                  */
/************************************************************************************/

$index = 1;
$module_name = basename( dirname( __FILE__ ) );

if (!eregi("modules.php", $_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

if( isset( $newlang ) ) {
   include( "modules/$module_name/language/lang-$newlang.php" );
   $language = $newlang;
} elseif ( isset( $lang ) ) {
   include( "modules/$module_name/language/lang-$lang.php" );
   $language = $lang;
} else {
   include( "modules/$module_name/language/lang-$language.php" );
}

require_once( "mainfile.php" );
require_once( "modules/$module_name/class.mstopsites.php" );

global $admin;
if( is_admin( $admin ) ) {
/******************************************************************************/
/* FUNCTION: MSTopSitesAdmin()                                                */
/* Admin menu of Top-Sites                                                    */
/******************************************************************************/
function MSTopSitesAdmin( )
{
   global $admin, $module_name, $db, $prefix,  $bgcolor1, $bgcolor2;
   $msts = new mstopsites();

   include( "header.php" );
   // Plot Header
   $msts->MSTopSitesPlotHeader();
   // Plot Menu
   echo "".$msts->MSTopSitesPlotMenu();

   if( ! is_admin( $admin ) ) { echo "".$msts->MSTopSitesMessageScreen( _MSTS_ADMINMODE, _MSTS_NOADMIN ); }
   else {
      echo "<center><br>\n";
      echo "<table border=\"1\" cellpadding=\"2\" cellspacing=\"0\" width=\"50%\" bgcolor=$bgcolor2 class=\"content\">\n";
      echo "<tr class=\"title\">\n";
      echo "<td width=\"100%\" bgcolor=$bgcolor2><p align=\"center\">< "._MSTS_ADMINMODE." ?></td>\n";
      echo "</tr>\n";
      echo "<tr><td width=\"100%\" align=\"center\" bgcolor=$bgcolor1><a href=\"modules.php?name=$module_name&file=mstopsitesadmin&amp;op=MSTopSitesAdminCheck\">"._MSTS_ADMINCHECK."</a></td></tr>\n";
      echo "<tr><td width=\"100%\" align=\"center\" bgcolor=$bgcolor1><a href=\"modules.php?name=$module_name&file=mstopsitesadmin&amp;op=MSTopSitesAdminCat\">"._MSTS_ADMINCAT."</a></td></tr>\n";
      echo "<tr><td width=\"100%\" align=\"center\" bgcolor=$bgcolor1><a href=\"modules.php?name=$module_name&file=mstopsitesadmin&amp;op=MSTopSitesAdminReset\">"._MSTS_ADMINRESET."</a></td></tr>\n";
      echo "<tr><td width=\"100%\" align=\"center\" bgcolor=$bgcolor1><a href=\"modules.php?name=$module_name&file=mstopsitesadmin&amp;op=MSTopSitesAdminClear\">"._MSTS_ADMINCLEAR."</a></td></tr>\n";
      echo "</table>\n";
      echo "</center><br><br>\n";

      $result = $db->sql_query( "SELECT webmaster_email, webmaster_url, topsite_name, img_button, img_visible, pp, webmaster_sendmail, bmaxdisplay, bmaxbutton, ranking, allow_reset, nbrdays, begindate, logip FROM $prefix"._mstopsites_cnf." WHERE id = '1'" );
      list( $webmaster_email, $webmaster_url, $topsite_name, $img_button, $img_visible, $pp, $webmaster_sendmail, $bmaxdisplay, $bmaxbutton, $ranking, $allow_reset, $nbrdays, $begindate, $logip ) = $db->sql_fetchrow( $result );
      
      echo "<center>\n";
      echo "<form action=\"modules.php?name=$module_name&file=mstopsitesadmin\" method=\"post\">\n";
      echo "<table border=\"1\" cellpadding=\"2\" cellspacing=\"0\" width=\"90%\" bgcolor=$bgcolor2 class=\"content\">\n";
      echo "<tr class=\"title\">\n";
      echo "<td width=\"100%\" colspan=\"2\" bgcolor=$bgcolor2>\n";
      echo "<p align=\"center\">< "._MSTS_ADMINSETTINGS." ?></td>\n";
      echo "</tr>\n";
      echo "<tr>\n";
      echo "<td width=\"50%\" bgcolor=$bgcolor1>"._MSTS_ADMINEMAIL."<br> (e.g. your-email@site.com)</td>\n";
      echo "<td width=\"50%\" bgcolor=$bgcolor1><input type=\"text\" name=\"webmaster_email\" value=\"$webmaster_email\" size=\"50\"></td>\n";
      echo "</tr>\n";
      echo "<tr>\n";
      echo "<td width=\"50%\" bgcolor=$bgcolor1>"._MSTS_ADMINURL."<br> (e.g. http://www.yoursite.com)</td>\n";
      echo "<td width=\"50%\" bgcolor=$bgcolor1><input type=\"text\" name=\"webmaster_url\" value=\"$webmaster_url\" size=\"50\"></td>\n";
      echo "</tr>\n";
      echo "<tr>\n";
      echo "<td width=\"50%\" bgcolor=$bgcolor1>"._MSTS_ADMINTSNAME."<br> (e.g. Your-Site-Name Top-Sites)</td>\n";
      echo "<td width=\"50%\" bgcolor=$bgcolor1><input type=\"text\" name=\"topsite_name\" value=\"$topsite_name\" size=\"50\"></td>\n";
      echo "</tr>\n";
      echo "<tr>\n";
      echo "<td width=\"50%\" bgcolor=$bgcolor1>"._MSTS_ADMINBUTTON."<br> (e.g. http://www.yoursite.com/yourbutton.gif)</td>\n";
      echo "<td width=\"50%\" bgcolor=$bgcolor1><input type=\"text\" name=\"img_button\" value=\"$img_button\" size=\"50\"></td>\n";
      echo "</tr>\n";
      echo "<tr>\n";
      echo "<td width=\"50%\" bgcolor=$bgcolor1>"._MSTS_ADMINBUTTONVIS."</td>\n";
      echo "<td width=\"50%\" bgcolor=$bgcolor1><input type=\"text\" name=\"img_visible\" value=\"$img_visible\" size=\"5\"></td>\n";
      echo "</tr>\n";
      echo "<tr>\n";
      echo "<td width=\"50%\" bgcolor=$bgcolor1>"._MSTS_ADMINPP."</td>\n";
      echo "<td width=\"50%\" bgcolor=$bgcolor1><input type=\"text\" name=\"pp\" value=\"$pp\" size=\"5\"></td>\n";
      echo "</tr>\n";
      echo "<tr>\n";
      echo "<td width=\"50%\" bgcolor=$bgcolor1>"._MSTS_ADMINSEND."</td>\n";
      echo "<td width=\"50%\" bgcolor=$bgcolor1>\n";
      // Set the E-mail send status
      if( $webmaster_sendmail == 0 )
      { 
         echo "<input type=\"radio\" name=\"webmaster_sendmail\" value=\"0\" checked><b>"._MSTS_NO."</b>&nbsp;&nbsp;
         <input type=\"radio\" name=\"webmaster_sendmail\" value=\"1\"><b>"._MSTS_YES."</b></td>";
      }
      else {
         echo "<input type=\"radio\" name=\"webmaster_sendmail\" value=\"0\" ><b>"._MSTS_NO."</b>&nbsp;&nbsp;
         <input type=\"radio\" name=\"webmaster_sendmail\" value=\"1\" checked><b>"._MSTS_YES."</b></td>";
      }      
      echo "</tr>\n";
      echo "<tr>\n";
      echo "<td width=\"50%\" bgcolor=$bgcolor1>"._MSTS_ADMINBDISP."</td>\n";
      echo "<td width=\"50%\" bgcolor=$bgcolor1><input type=\"text\" name=\"bmaxdisplay\" value=\"$bmaxdisplay\" size=\"5\"></td>\n";
      echo "</tr>\n";
      echo "<tr>\n";
      echo "<td width=\"50%\" bgcolor=$bgcolor1>"._MSTS_ADMINBBUT."</td>\n";
      echo "<td width=\"50%\" bgcolor=$bgcolor1><input type=\"text\" name=\"bmaxbutton\" value=\"$bmaxbutton\" size=\"5\"></td>\n";
      echo "</tr>\n";
      echo "<tr>\n";
      echo "<td width=\"50%\" bgcolor=$bgcolor1>"._MSTS_ADMINRANKING."</td>\n";
      echo "<td width=\"50%\" bgcolor=$bgcolor1>\n";
      // Set the Ranking Status
      if( $ranking == 0 )
      { 
         echo "<input type=\"radio\" name=\"ranking\" value=\"0\" checked><b>"._MSTS_ADMINRANKVI."</b>&nbsp;&nbsp;
         <input type=\"radio\" name=\"ranking\" value=\"1\"><b>"._MSTS_ADMINRANKTV."</b></td>";
      }
      else {
         echo "<input type=\"radio\" name=\"ranking\" value=\"0\" ><b>"._MSTS_ADMINRANKVI."</b>&nbsp;&nbsp;
         <input type=\"radio\" name=\"ranking\" value=\"1\" checked><b>"._MSTS_ADMINRANKTV."</b></td>";
      }
      echo "</tr>\n";
      echo "<tr>\n";
      echo "<td width=\"50%\" bgcolor=$bgcolor1>"._MSTS_ADMINLOGIP."</td>\n";
      echo "<td width=\"50%\" bgcolor=$bgcolor1>\n";
      // Set the Logging IP Status
      if( $logip == 0 )
      { 
         echo "<input type=\"radio\" name=\"logip\" value=\"0\" checked><b>"._MSTS_NO."</b>&nbsp;&nbsp;
         <input type=\"radio\" name=\"logip\" value=\"1\"><b>"._MSTS_YES."</b></td>";
      }
      else {
         echo "<input type=\"radio\" name=\"logip\" value=\"0\" ><b>"._MSTS_NO."</b>&nbsp;&nbsp;
         <input type=\"radio\" name=\"logip\" value=\"1\" checked><b>"._MSTS_YES."</b></td>";
      }
      echo "</tr>\n";
      echo "<tr>\n";
      echo "<td width=\"50%\" bgcolor=$bgcolor1 rowspan=\"2\">"._MSTS_ADMINAUTORESET."</td>\n";
      echo "<td width=\"50%\" bgcolor=$bgcolor1>\n";
      // Allow Auto reset of Statistics or not 
      if( $allow_reset == 0 )
      { 
         echo "<input type=\"radio\" name=\"allow_reset\" value=\"0\" checked><b>"._MSTS_NO."</b>&nbsp;&nbsp;
         <input type=\"radio\" name=\"allow_reset\" value=\"1\"><b>"._MSTS_YES."</b></td>";
      }
      else {
         echo "<input type=\"radio\" name=\"allow_reset\" value=\"0\" ><b>"._MSTS_NO."</b>&nbsp;&nbsp;
         <input type=\"radio\" name=\"allow_reset\" value=\"1\" checked><b>"._MSTS_YES."</b></td>";
      }      
      echo "</td></tr>\n";
      echo "<tr>\n";
      // Dates for Auto Reset Statistics
      $ebegindate = explode( "-", $begindate );
      $startday = $ebegindate[ 2 ]; $startmonth = $ebegindate[ 1 ]; $startyear = $ebegindate[ 0 ];
      echo "<td width=\"50%\" bgcolor=$bgcolor1>"._MSTS_ADMINEVERY."&nbsp;<select size=\"1\" name=\"nbrdays\">\n";
      for( $i = 1; $i < 121; $i++ ) { if( $i == $nbrdays ) { echo "<option selected>$i</option>\n"; } else { echo "<option>$i</option>\n"; } }
      echo "</select>&nbsp;"._MSTS_ADMINSTARTFROM."&nbsp;<br>\n";
      
      echo "<select size=\"1\" name=\"startday\">\n";
      for( $i = 1; $i < 32; $i++ ) { if( strlen( $i ) == 1 ) $i = "0" . $i; if( $i == $startday ) { echo "<option selected>$i</option>\n"; } else { echo "<option>$i</option>\n"; } }
      echo "</select>&nbsp;-\n";
      echo "<select size=\"1\" name=\"startmonth\">\n";
      for( $i = 1; $i < 13; $i++ ) { if( strlen( $i ) == 1 ) $i = "0" . $i; if( $i == $startmonth ) { echo "<option selected>$i</option>\n"; } else { echo "<option>$i</option>\n"; } }
      echo "</select>&nbsp;-\n";
      echo "<select size=\"1\" name=\"startyear\">\n";
      for( $i = 2002; $i < 2026; $i++ ) { if( $i == $startyear ) { echo "<option selected>$i</option>\n"; } else { echo "<option>$i</option>\n"; } }
      echo "</select><br>\n";
      echo "<font color=\"#FF0000\"><b>\n";
      if( $allow_reset == 0 ) { echo "&nbsp;" . _MSTS_ADMINNOAUTO . "<br>\n"; } else { echo "&nbsp;" . _MSTS_ADMINYESAUTO . "<br>\n"; }
      echo "</b></font></td>\n";      
      
      echo "</tr>\n";
      echo "<tr>\n";
      echo "<td width=\"100%\" valign=\"top\" colspan=\"2\" bgcolor=$bgcolor1>\n";
      echo "<input type=\"hidden\" name=\"uname\" value=\"$uname\">\n";
      echo "<input type=\"hidden\" name=\"op\" value=\"MSTopSitesAdminSave\">\n";
      echo "<p align=\"center\"><input type=\"submit\" value=\""._MSTS_SAVESITE."\"></td>\n";
      echo "</tr>\n";
      echo "</table>\n";
      echo "</form>\n";
      echo "</center>\n";            
   }
   // Plot footer    
   $msts->MSTopSitesPlotFooter();   
   include( "footer.php" );
}

/******************************************************************************/
/* FUNCTION: MSTopSitesAdminSave()                                            */
/* Save Admin Configuration Settings                                          */
/******************************************************************************/
function MSTopSitesAdminSave( $webmaster_email, $webmaster_url, $topsite_name, $img_button, $img_visible, $pp, $webmaster_sendmail, $bmaxdisplay, $bmaxbutton, $ranking, $logip, $allow_reset, $nbrdays, $startday, $startmonth, $startyear )
{
   global $module_name, $db, $prefix, $bgcolor1, $bgcolor2;
   $msts = new mstopsites();

   include( "header.php" );
   // Plot Header
   $msts->MSTopSitesPlotHeader();
   // Plot Menu
   echo "".$msts->MSTopSitesPlotMenu();

   if( $webmaster_email == "" || $webmaster_url == "" || $topsite_name == "" || $img_button == "" || $img_visible == "" || $pp == "" || $bmaxdisplay == "" || $bmaxbutton == "" ) {
      echo $msts->MSTopSitesMessageScreen( _MSTS_ADMINSETTINGS, _MSTS_ALLFIELDS );
   }
   else {
	  $begindate = $startyear . "-" . $startmonth . "-" . $startday;
      $result = $db->sql_query( "UPDATE $prefix"._mstopsites_cnf." SET 
            webmaster_email = '$webmaster_email', webmaster_url = '$webmaster_url', topsite_name = '$topsite_name',
            img_button = '$img_button', img_visible = '$img_visible', pp = '$pp', webmaster_sendmail = '$webmaster_sendmail',
            bmaxdisplay = '$bmaxdisplay', bmaxbutton = '$bmaxbutton', ranking = '$ranking', logip = '$logip', allow_reset = '$allow_reset',
            nbrdays = '$nbrdays', begindate = '$begindate'
      WHERE id = '1'" );

      // Plott Confirmation Screen
      echo "".$msts->MSTopSitesConfirmationScreen( _MSTS_ADMINSETTINGS, _MSTS_ADMINSETTINGSSAVED );
   }
   
   // Plot footer
   $msts->MSTopSitesPlotFooter();
   include( "footer.php" );   
}

/******************************************************************************/
/* FUNCTION: MSTopSitesReset()                                                */
/* Reset all Members Statistics                                               */
/******************************************************************************/
function MSTopSitesAdminReset( )
{
   global $module_name;
   $msts = new mstopsites();

   include( "header.php" );
   // Plot Header
   $msts->MSTopSitesPlotHeader();
   // Plot Menu
   echo "".$msts->MSTopSitesPlotMenu();

   echo "<h4 align=center><b>"._MSTS_ADMINRESET1."</b></h4>";
   echo "<br>\n";
   OpenTable();
   echo "<center>[ <a href=\"javascript:history.go( -1 )\">"._MSTS_BACK."</a> ]&nbsp;&nbsp;<b></b>&nbsp;&nbsp;[ <a href=\"modules.php?name=$module_name&file=mstopsitesadmin&amp;op=MSTopSitesAdminReset1\">"._MSTS_ADMINRESET2."</a> ]</center>\n";
   CloseTable();
    
   // Plot footer
   $msts->MSTopSitesPlotFooter();
   include( "footer.php" );   
}

/******************************************************************************/
/* FUNCTION: MSTopSitesReset1()                                               */
/* Reset all Members Statistics                                               */
/******************************************************************************/
function MSTopSitesAdminReset1( )
{
   global $module_name, $db, $prefix;
   $msts = new mstopsites();

   include( "header.php" );
   // Plot Header
   $msts->MSTopSitesPlotHeader();
   // Plot Menu
   echo "".$msts->MSTopSitesPlotMenu();
   
   // Reset all Members in Database
   $today = date( "Y-m-d G:i:s" );
   $result = $db->sql_query( "SELECT memberid FROM $prefix"._mstopsites );
   while( list( $memberid ) = $db->sql_fetchrow( $result ) ) {
      $result1 = $db->sql_query( "UPDATE $prefix"._mstopsites." SET startdate = '$today', curdate = '$today', daysold = '0', hitsin = '0', hitsout = '0', hitstotal = '0', hitstoday = '0', rating = '0' WHERE memberid = '$memberid'" );
   }
   // Reset the IP Table
   $result = $db->sql_query( "DELETE FROM $prefix"._mstopsites_ip." " );
   // Plot Confirmation Screen
   echo "".$msts->MSTopSitesConfirmationScreen( _MSTS_ADMINRESET, _MSTS_ADMINRESET3 );

   // Plot footer
   $msts->MSTopSitesPlotFooter();
   include( "footer.php" );
}

/******************************************************************************/
/* FUNCTION: MSTopSitesClear()                                                */
/* Delete all Member Sites                                                    */
/******************************************************************************/
function MSTopSitesAdminClear( )
{
   global $module_name;
   $msts = new mstopsites();

   include( "header.php" );
   // Plot Header
   $msts->MSTopSitesPlotHeader();
   // Plot Menu
   echo "".$msts->MSTopSitesPlotMenu();
   
   echo "<h4 align=center><b>"._MSTS_ADMINCLEAR1."</b></h4>";
   echo "<br>\n";
   OpenTable();
   echo "<center>[ <a href=\"javascript:history.go( -1 )\">"._MSTS_BACK."</a> ]&nbsp;&nbsp;<b></b>&nbsp;&nbsp;[ <a href=\"modules.php?name=$module_name&file=mstopsitesadmin&amp;op=MSTopSitesAdminClear1\">"._MSTS_ADMINCLEAR2."</a> ]</center>\n";
   CloseTable();   

   // Plot footer
   $msts->MSTopSitesPlotFooter();
   include( "footer.php" );   
}

/******************************************************************************/
/* FUNCTION: MSTopSitesClear1()                                               */
/* Delete all Member Sites                                                    */
/******************************************************************************/
function MSTopSitesAdminClear1( )
{
   global $module_name, $db, $prefix;
   $msts = new mstopsites();

   include( "header.php" );
   // Plot Header
   $msts->MSTopSitesPlotHeader();
   // Plot Menu
   echo "".$msts->MSTopSitesPlotMenu();

   // Delete all Members from Database
   $result = $db->sql_query( "SELECT memberid FROM $prefix"._mstopsites );
   while( list( $memberid ) = $db->sql_fetchrow( $result ) ) {
      $result1 = $db->sql_query( "DELETE FROM $prefix"._mstopsites." WHERE memberid = '$memberid'" );
   }
   // Reset the IP Table
   $result = $db->sql_query( "DELETE FROM $prefix"._mstopsites_ip );
   // Plot Confirmation Screen
   echo "".$msts->MSTopSitesConfirmationScreen( _MSTS_ADMINCLEAR, _MSTS_ADMINCLEAR3 );

   // Plot footer
   $msts->MSTopSitesPlotFooter();
   include( "footer.php" );
}

/******************************************************************************/
/* FUNCTION: MSTopSitesCheck()                                                */
/* Edit/Check/Maintain Members Settings                                       */
/******************************************************************************/
function MSTopSitesAdminCheck( )
{
   global $module_name, $db, $prefix, $bgcolor1, $bgcolor2;
   $msts = new mstopsites();

   include( "header.php" );
   // Plot Header
   $msts->MSTopSitesPlotHeader();
   // Plot Menu
   echo "".$msts->MSTopSitesPlotMenu();

   // Draw table and display all subscribed members
   echo "<div align=\"center\">\n";
   echo "<table border=\"1\" cellpadding=\"2\" cellspacing=\"0\" width=\"90%\" bgcolor=$bgcolor2 class=\"content\">\n";
   echo "<tr class=\"title\">\n";
   echo "<td width=\"10%\" bgcolor=$bgcolor2><p align=\"center\">"._MSTS_EDITSITE."</td>\n";
   echo "<td width=\"10%\" bgcolor=$bgcolor2><p align=\"center\">"._MSTS_DELETESITE."</td>\n";
   echo "<td width=\"65%\" bgcolor=$bgcolor2><p align=\"center\">"._MSTS_DESCRIPTION."</td>\n";
   echo "<td width=\"15%\" bgcolor=$bgcolor2><p align=\"center\">"._MSTS_ADMINRESET4."</td>\n";   
   echo "</tr>\n";
   $result = $db->sql_query( "SELECT memberid, sitename, description FROM $prefix"._mstopsites." ORDER BY memberid ASC" );
   $counter = 1;
   while( list( $memberid, $sname, $description ) = $db->sql_fetchrow( $result ) ) {
      $sname = htmlspecialchars( $sname );	   
      $description = htmlspecialchars( $description );
      echo "<tr>\n";
      echo "<td width=\"10%\" bgcolor=$bgcolor2><p align=\"center\"><b><a href=\"modules.php?name=$module_name&file=mstopsitesadmin&op=MSTopSitesAdminEditSite&id=$memberid\"><img src=\"modules/$module_name/images/edit.gif\" ALT=\""._MSTS_EDITSITE."\" border=\"0\"> $counter</b></a></td>\n";
      echo "<td width=\"10%\" bgcolor=$bgcolor2><p align=\"center\"><b><a href=\"modules.php?name=$module_name&file=mstopsitesadmin&op=MSTopSitesAdminDeleteSite&id=$memberid\"><img src=\"modules/$module_name/images/delete.gif\" ALT=\""._MSTS_DELETESITE."\" border=\"0\"> $counter</b></a></td>\n";      
      $description = wordwrap( $description, 75, "\n", 1 );
      echo "<td width=\"65%\" bgcolor=$bgcolor1><center><font color=\"#FF0000\">$sname</font></center><br><br>$description</td>\n";
      echo "<td width=\"15%\" bgcolor=$bgcolor1><p align=\"center\"><b><a href=\"modules.php?name=$module_name&file=mstopsitesadmin&op=MSTopSitesAdminResetSite&id=$memberid\"><img src=\"modules/$module_name/images/reset.gif\" ALT=\""._MSTS_ADMINRESET4."\" border=\"0\"> $counter</b></a></td>\n";
      echo "</tr>\n";
      $counter += 1;
   }
   echo "</table></div>\n";
   echo "<br><center>[ <a href=\"javascript:history.go( -1 )\">"._MSTS_BACK."</a> ]</center>\n";
      
   // Plot footer
   $msts->MSTopSitesPlotFooter();
   include( "footer.php" );   
}

/******************************************************************************/
/* FUNCTION: MSTopSitesCat()                                                  */
/* Edit/Maintain Categories                                                   */
/******************************************************************************/
function MSTopSitesAdminCat( )
{
   global $module_name, $db, $prefix, $bgcolor1, $bgcolor2;
   $msts = new mstopsites();

   include( "header.php" );
   // Plot Header
   $msts->MSTopSitesPlotHeader();
   // Plot Menu
   echo "".$msts->MSTopSitesPlotMenu();

   // Get category Names
   $result1 = $db->sql_query( "SELECT categories FROM $prefix"._mstopsites_cnf." WHERE id = '1'" );
   list( $categories ) = $db->sql_fetchrow( $result1 );
   $ecategories = explode( '|', $categories );

   // Categories Table
   echo "<br><div align=\"center\">\n";
   echo "<center><table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" style=\"border-collapse: collapse\" bordercolor=\"#111111\" width=\"80%\" bgcolor=\"$bgcolor2\">\n";
   echo "<tr>\n";
   echo "<td width=\"10%\" align=\"center\" height=\"30\"><b>"._MSTS_NBR."</b></td>\n";
   echo "<td width=\"15%\" align=\"center\" height=\"30\"><b>"._MSTS_EDITCAT."</b></td>\n";
   echo "<td width=\"15%\" align=\"center\" height=\"30\"><b>"._MSTS_DELETECAT."</b></td>\n";
   echo "<td width=\"60%\" align=\"center\" height=\"30\"><b>"._MSTS_CATEGORY."</b></td>\n";
   echo "</tr>\n";

   $counter = 0; $nbr = 1;
   for( $i = 0; $i < sizeof( $ecategories ); $i++ ) {
      $cat = $ecategories[ $i ];
      echo "<tr>\n";
      echo "<td width=\"10%\" align=\"center\" bgcolor=\"$bgcolor1\">$nbr</td>\n";
      echo "<td width=\"15%\" align=\"center\" bgcolor=\"$bgcolor1\"><a href=\"modules.php?name=$module_name&file=mstopsitesadmin&op=MSTopSitesAdminModCat&cat=$counter\"><img src=\"modules/$module_name/images/edit.gif\" ALT=\""._MSTS_EDITCAT."\" border=\"0\"></b></a></td>\n";
      echo "<td width=\"15%\" align=\"center\" bgcolor=\"$bgcolor1\"><a href=\"modules.php?name=$module_name&file=mstopsitesadmin&op=MSTopSitesAdminDeleteCat&cat=$counter\"><img src=\"modules/$module_name/images/delete.gif\" ALT=\""._MSTS_DELETECAT."\" border=\"0\"></b></a></td>\n";
      echo "<td width=\"60%\" align=\"center\" bgcolor=\"$bgcolor1\">$cat</td>\n";
      echo "</tr>\n";
      $counter += 1; $nbr += 1;
   }
   echo "<tr>\n";   
   echo "<td width=\"100%\" colspan=\"4\" align=\"center\" height=\"30\" bgcolor=\"$bgcolor2\"><a href=\"modules.php?name=$module_name&file=mstopsitesadmin&op=MSTopSitesAdminModCat&cat=-1\"><img src=\"modules/$module_name/images/edit.gif\" ALT=\""._MSTS_ADDCAT."\" border=\"0\">"._MSTS_ADDCAT."</b></a></td>\n";
   echo "</tr>\n";
   echo "</table></center></div>";
   echo "<br><center>[ <a href=\"javascript:history.go( -1 )\">"._MSTS_BACK."</a> ]</center>\n";
   
   // Plot footer
   $msts->MSTopSitesPlotFooter();
   include( "footer.php" );   
}

/******************************************************************************/
/* FUNCTION: MSTopSitesAdminEditSite()                                        */
/* Admin wants to edit a Site                                                 */
/******************************************************************************/
function MSTopSitesAdminEditSite( $id )
{
   global $module_name, $db, $prefix, $bgcolor1, $bgcolor2;
   $msts = new mstopsites();

   include( "header.php" );
   // Plot Header
   $msts->MSTopSitesPlotHeader();
   // Plot Menu
   echo "".$msts->MSTopSitesPlotMenu();   

   $result = $db->sql_query( "SELECT uname, sitename, url, buttonurl, email, description, category FROM $prefix"._mstopsites." WHERE memberid = '$id'" );
   list( $uname, $sname, $url, $buttonurl, $email, $description, $category ) = $db->sql_fetchrow( $result );  
   $result1 = $db->sql_query( "SELECT webmaster_email, categories FROM $prefix"._mstopsites_cnf." WHERE id = '1'" );
   list( $webmaster_email, $categories ) = $db->sql_fetchrow( $result1 );
   $ecategories = explode( '|', $categories );

   echo "<center>\n";
   echo "<form action=\"modules.php?name=$module_name&file=mstopsitesadmin\" method=\"post\">\n";
   echo "<table border=\"1\" cellpadding=\"2\" cellspacing=\"0\" width=\"90%\" bgcolor=$bgcolor2 class=\"content\">\n";
   echo "<tr class=\"title\">\n";
   echo "<td width=\"100%\" colspan=\"2\" bgcolor=$bgcolor2>\n";
   echo "<p align=\"center\">< "._MSTS_EDITSITE." ?></td>\n";
   echo "</tr>\n";
   echo "<tr>\n";
   echo "<td width=\"50%\" bgcolor=$bgcolor1>"._MSTS_USERNAME."</td>\n";
   echo "<td width=\"50%\" bgcolor=$bgcolor1><font color=\"#FF0000\">$uname</font></td>\n";
   echo "</tr>\n";   
   echo "<tr>\n";
   echo "<td width=\"50%\" bgcolor=$bgcolor1>"._MSTS_SITENAME."</td>\n";
   echo "<td width=\"50%\" bgcolor=$bgcolor1><input type=\"text\" name=\"sname\" value=\"".htmlspecialchars($sname)."\" size=\"50\"></td>\n";
   echo "</tr>\n";
   echo "<tr>\n";
   echo "<td width=\"50%\" bgcolor=$bgcolor1>"._MSTS_URL."<br> (e.g. http://www.yoursite.com)</td>\n";
   echo "<td width=\"50%\" bgcolor=$bgcolor1><input type=\"text\" name=\"url\" value=\"".htmlspecialchars($url)."\" size=\"50\"></td>\n";
   echo "</tr>\n";
   echo "<tr>\n";
   echo "<td width=\"50%\" bgcolor=$bgcolor1>"._MSTS_EMAIL."<br> (e.g. your-email@site.com)</td>\n";
   echo "<td width=\"50%\" bgcolor=$bgcolor1><input type=\"text\" name=\"email\" value=\"".htmlspecialchars($email)."\" size=\"50\"></td>\n";
   echo "</tr>\n";   
   echo "<tr>\n";
   echo "<td width=\"50%\" bgcolor=$bgcolor1>"._MSTS_BUTTON."<br> (e.g. http://www.yoursite.com/yourbutton.gif)</td>\n";
   echo "<td width=\"50%\" bgcolor=$bgcolor1><input type=\"text\" name=\"buttonurl\" value=\"".htmlspecialchars($buttonurl)."\" size=\"50\"></td>\n";
   echo "</tr>\n";
   echo "<tr>\n";
   echo "<td width=\"50%\" valign=\"top\" bgcolor=$bgcolor1>"._MSTS_CATEGORY."<br><br>"._MSTS_CATEGORYMISSING.": $webmaster_email</td>\n";
   // Show various categories
   echo "<td width=\"50%\" bgcolor=$bgcolor1><select size=\"1\" name=\"cat\">\n";
   for( $i = 0; $i < sizeof( $ecategories ); $i++ ) { if( strcmp( $ecategories[ $i ], $category ) == 0 ) { echo "<option selected>".$ecategories[ $i ]."</option>\n"; } else { echo "<option>".$ecategories[ $i ]."</option>\n"; } }
   echo "</select></td>\n";
   echo "</tr>\n";
   echo "<tr>\n";
   echo "<td width=\"50%\" valign=\"top\" bgcolor=$bgcolor1>"._MSTS_DESCRIPTION."</td>\n";
   echo "<td width=\"50%\" bgcolor=$bgcolor1><textarea rows=\"7\" name=\"description\" cols=\"50\">".htmlspecialchars($description)."</textarea></td>\n";
   echo "</tr>\n";
   echo "<tr>\n";
   echo "<td width=\"100%\" valign=\"top\" colspan=\"2\" bgcolor=$bgcolor1>\n";
   echo "<input type=\"hidden\" name=\"uname\" value=\"$uname\">\n";
   echo "<input type=\"hidden\" name=\"op\" value=\"MSTopSitesAdminSaveSite\">\n";
   echo "<p align=\"center\"><input type=\"submit\" value=\""._MSTS_SAVESITE."\"></td>\n";
   echo "</tr>\n";
   echo "</table>\n";
   echo "</form>\n";
   echo "</center>\n";
   
   // Plot footer
   $msts->MSTopSitesPlotFooter();
   include( "footer.php" );
}

/******************************************************************************/
/* FUNCTION: MSTopSitesAdminSaveSite()                                        */
/* Check if all apply settings are entered and then update Site               */
/******************************************************************************/
function MSTopSitesAdminSaveSite( $uname, $sname, $url, $email, $buttonurl, $description, $cat )
{
   global $module_name, $db, $prefix, $bgcolor1, $bgcolor2;

   if( $uname == "" || $sname == "" || $url == "" || $email == "" || $description == "" ) {
      $msts = new mstopsites();
      include( "header.php" );
      // Plot Header
      $msts->MSTopSitesPlotHeader();
      // Plot Menu
      echo "".$msts->MSTopSitesPlotMenu();	   
      echo $msts->MSTopSitesMessageScreen( _MSTS_EDITSITE, _MSTS_ALLFIELDSREG );
      // Plot footer
      $msts->MSTopSitesPlotFooter();
      include( "footer.php" );
   }
   else {
      $result = $db->sql_query( "update $prefix"._mstopsites." set sitename = '$sname', url = '$url', email = '$email', buttonurl = '$buttonurl', description = '$description', category = '$cat' where uname = '$uname'" );
      // Return
      MSTopSitesAdminCheck();
   }
}

/******************************************************************************/
/* FUNCTION: MSTopSitesAdminDeleteSite()                                      */
/* Delete a Site from the Database                                            */
/******************************************************************************/
function MSTopSitesAdminDeleteSite( $id )
{
   global $module_name, $db, $prefix;
   $msts = new mstopsites();

   include( "header.php" );
   // Plot Header
   $msts->MSTopSitesPlotHeader();
   // Plot Menu
   echo "".$msts->MSTopSitesPlotMenu();  
   
   echo "<h4 align=center><b>"._MSTS_ADMINDELETESITE."</b></h4>";
   echo "<br>\n";
   OpenTable();
   echo "<center>[ <a href=\"javascript:history.go( -1 )\">"._MSTS_BACK."</a> ]&nbsp;&nbsp;<b></b>&nbsp;&nbsp;[ <a href=\"modules.php?name=$module_name&file=mstopsitesadmin&amp;op=MSTopSitesAdminDeleteSite1&amp;id=$id\">"._MSTS_DELETESITE."</a> ]</center>\n";
   CloseTable();
   
   // Plot footer
   $msts->MSTopSitesPlotFooter();
   include( "footer.php" );
}

/******************************************************************************/
/* FUNCTION: MSTopSitesAdminDeleteSite1()                                     */
/* Delete a Site from the Database                                            */
/******************************************************************************/
function MSTopSitesAdminDeleteSite1( $id )
{
   global $module_name, $db, $prefix;

   // Delete a Member from Database
   $result = $db->sql_query( "DELETE FROM $prefix"._mstopsites." WHERE memberid = '$id'" );
   // Delete voted IP's for that member
   $result = $db->sql_query( "SELECT memberid FROM $prefix"._mstopsites_ip." where memberid='$id'" );
   while( list( $memberid ) = $db->sql_fetchrow( $result ) ) {
      $result1 = $db->sql_query( "DELETE FROM $prefix"._mstopsites_ip." WHERE memberid='$id'" );
   }
   
   // Return
   MSTopSitesAdminCheck();
}

/******************************************************************************/
/* FUNCTION: MSTopSitesAdminResetSite()                                       */
/* Reset a Site's statistics                                                  */
/******************************************************************************/
function MSTopSitesAdminResetSite( $id )
{
   global $module_name, $db, $prefix;
   $msts = new mstopsites();

   include( "header.php" );
   // Plot Header
   $msts->MSTopSitesPlotHeader();
   // Plot Menu
   echo "".$msts->MSTopSitesPlotMenu();  
   
   echo "<h4 align=center><b>"._MSTS_ADMINRESET5."</b></h4>";
   echo "<br>\n";
   OpenTable();
   echo "<center>[ <a href=\"javascript:history.go( -1 )\">"._MSTS_BACK."</a> ]&nbsp;&nbsp;<b></b>&nbsp;&nbsp;[ <a href=\"modules.php?name=$module_name&file=mstopsitesadmin&amp;op=MSTopSitesAdminResetSite1&amp;id=$id\">"._MSTS_ADMINRESET4."</a> ]</center>\n";
   CloseTable();
   
   // Plot footer
   $msts->MSTopSitesPlotFooter();
   include( "footer.php" );
}

/******************************************************************************/
/* FUNCTION: MSTopSitesAdminResetSite1()                                      */
/* Reset a Site's statistics                                                  */
/******************************************************************************/
function MSTopSitesAdminResetSite1( $id )
{
   global $module_name, $db, $prefix;

   // Reset statistics for this site
   $today = date( "Y-m-d G:i:s" );
   $result = $db->sql_query( "UPDATE $prefix"._mstopsites." SET startdate = '$today', curdate = '$today', daysold = '0', hitsin = '0', hitsout = '0', hitstotal = '0', hitstoday = '0', rating = '0' WHERE memberid = '$id'" );
   // Delete voted IP's
   $result = $db->sql_query( "SELECT memberid FROM $prefix"._mstopsites_ip." where memberid='$id'" );
   while( list( $memberid ) = $db->sql_fetchrow( $result ) ) {
      $result1 = $db->sql_query( "DELETE FROM $prefix"._mstopsites_ip." WHERE memberid='$id'" );
   }
   
   // Return
   MSTopSitesAdminCheck();
}

/******************************************************************************/
/* FUNCTION: MSTopSitesAdminDeleteCat()                                       */
/* Delete a Category from the Database                                        */
/******************************************************************************/
function MSTopSitesAdminDeleteCat( $cat )
{
   global $module_name, $db, $prefix;
   $msts = new mstopsites();

   include( "header.php" );
   // Plot Header
   $msts->MSTopSitesPlotHeader();
   // Plot Menu
   echo "".$msts->MSTopSitesPlotMenu();
   
   echo "<h4 align=center><b>"._MSTS_DELETECAT."</b></h4>";
   echo "<br>\n";
   OpenTable();
   echo "<center>[ <a href=\"javascript:history.go( -1 )\">"._MSTS_BACK."</a> ]&nbsp;&nbsp;<b></b>&nbsp;&nbsp;[ <a href=\"modules.php?name=$module_name&file=mstopsitesadmin&amp;op=MSTopSitesAdminDeleteCat1&amp;cat=$cat\">"._MSTS_DELETECAT."</a> ]</center>\n";
   CloseTable();
   
   // Plot footer
   $msts->MSTopSitesPlotFooter();
   include( "footer.php" );
}

/******************************************************************************/
/* FUNCTION: MSTopSitesAdminDeleteCat1()                                      */
/* Delete a Category from the Database                                        */
/******************************************************************************/
function MSTopSitesAdminDeleteCat1( $cat )
{
   global $module_name, $db, $prefix;

   // Get category Names
   $result1 = $db->sql_query( "SELECT categories FROM $prefix"._mstopsites_cnf." WHERE id = '1'" );
   list( $categories ) = $db->sql_fetchrow( $result1 );
   $ecategories = explode( '|', $categories );
   // Delete Category from array
   unset( $ecategories[ $cat ] );
   $icat = implode( '|', $ecategories );
   $result = $db->sql_query( "update $prefix"._mstopsites_cnf." set categories = '$icat' where id = '1'" );
   
   // return
   MSTopSitesAdminCat();
}

/******************************************************************************/
/* FUNCTION: MSTopSitesAdminModCat                                            */
/* Add a new Category or Modify an existing one                               */
/******************************************************************************/
function MSTopSitesAdminModCat( $cat )
{
   global $module_name, $db, $prefix, $bgcolor1, $bgcolor2;
   $msts = new mstopsites();

   include( "header.php" );
   // Plot Header
   $msts->MSTopSitesPlotHeader();
   // Plot Menu
   echo "".$msts->MSTopSitesPlotMenu();

   // Add a new Category or Modify an existing one
   echo "<br>"; OpenTable();
   echo "<br><div align=\"center\">\n";
   echo "<form action=\"modules.php?name=$module_name&file=mstopsitesadmin\" method=\"post\">\n";   
   echo "<center><table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" style=\"border-collapse: collapse\" bordercolor=\"#111111\" width=\"60%\" bgcolor=\"$bgcolor2\">\n";
   echo "<tr>\n";
   
   if( $cat == -1 ) echo "<td width=\"100%\" colspan=\"2\" align=\"center\" height=\"30\"><b>"._MSTS_ADDCAT."</b></td>\n";
   else echo "<td width=\"100%\" colspan=\"2\" align=\"center\" height=\"30\"><b>"._MSTS_EDITCAT."</b></td>\n";
   
   echo "</tr>\n";
   echo "<tr>\n";   
   echo "<td width=\"30%\" bgcolor=\"$bgcolor1\" align=\"center\" height=\"30\"><b>"._MSTS_CATEGORY."</b></td>\n";
   
   if( $cat != -1 ) {
      // Get category Names
      $result1 = $db->sql_query( "SELECT categories FROM $prefix"._mstopsites_cnf." WHERE id = '1'" );
      list( $categories ) = $db->sql_fetchrow( $result1 );
      $ecategories = explode( '|', $categories );
      $ncat = $ecategories[ $cat ];
   }
   else { $ncat = ""; }
   
   echo "<td width=\"70%\" bgcolor=\"$bgcolor1\" align=\"center\" height=\"30\"><input type=\"text\" name=\"ncat\" value=\"$ncat\" size=\"30\"></td>\n";
   echo "</tr>\n";
   echo "<td width=\"100%\" colspan=\"2\" valign=\"top\" colspan=\"2\" bgcolor=$bgcolor1><br>\n";
   echo "<input type=\"hidden\" name=\"cat\" value=\"$cat\">\n";
   echo "<input type=\"hidden\" name=\"op\" value=\"MSTopSitesAdminModCat1\">\n";
   echo "<p align=\"center\"><input type=\"submit\" value=\""._MSTS_SAVESITE."\"></td>\n";   
   echo "</table></form></center></div>";
   echo "<center>[ <a href=\"javascript:history.go( -1 )\">"._MSTS_BACK."</a> ]</center>\n";
   CloseTable();
   
   // Plot footer
   $msts->MSTopSitesPlotFooter();
   include( "footer.php" );
}

/******************************************************************************/
/* FUNCTION: MSTopSitesAdminModCat1                                           */
/* Add a new Category or Modify an existing one                               */
/******************************************************************************/
function MSTopSitesAdminModCat1( $ncat, $cat )
{
   global $module_name, $db, $prefix, $bgcolor1, $bgcolor2;
   
   if( $ncat == "" ) {   
      $msts = new mstopsites();
      include( "header.php" );
      // Plot Header
      $msts->MSTopSitesPlotHeader();
      // Plot Menu
      echo "".$msts->MSTopSitesPlotMenu();
      echo $msts->MSTopSitesMessageScreen( _MSTS_ADDCAT, _MSTS_ALLFIELDS );
      // Plot footer
      $msts->MSTopSitesPlotFooter();
      include( "footer.php" );      
   }
   else {
      if( $cat == -1 ) {	   
         // Get category Names
         $result1 = $db->sql_query( "SELECT categories FROM $prefix"._mstopsites_cnf." WHERE id = '1'" );
         list( $categories ) = $db->sql_fetchrow( $result1 );	   
         $categories = $categories . "|" . $ncat;
         $result = $db->sql_query( "update $prefix"._mstopsites_cnf." set categories = '$categories' where id = '1'" );
      }
	  else {
         // Get category Names
         $result1 = $db->sql_query( "SELECT categories FROM $prefix"._mstopsites_cnf." WHERE id = '1'" );
         list( $categories ) = $db->sql_fetchrow( $result1 );
         $ecategories = explode( '|', $categories );
         // Modify Category from array
         $ecategories[ $cat ] = $ncat;
         $icat = implode( '|', $ecategories );
         $result = $db->sql_query( "update $prefix"._mstopsites_cnf." set categories = '$icat' where id = '1'" );
      }
      // Return
      MSTopSitesAdminCat();
   }
}

/***************************************************/
/****************** PROGRAM START ******************/
/***************************************************/
switch( $op )
{
    case "MSTopSitesAdmin":
       MSTopSitesAdmin( );
    break;

    case "MSTopSitesAdminSave":
       MSTopSitesAdminSave( $webmaster_email, $webmaster_url, $topsite_name, $img_button, $img_visible, $pp, $webmaster_sendmail, $bmaxdisplay, $bmaxbutton, $ranking, $logip, $allow_reset, $nbrdays, $startday, $startmonth, $startyear );
    break;

    case "MSTopSitesAdminReset":
       MSTopSitesAdminReset( );
    break;

    case "MSTopSitesAdminReset1":
       MSTopSitesAdminReset1( );
    break;

    case "MSTopSitesAdminClear":
       MSTopSitesAdminClear( );
    break;

    case "MSTopSitesAdminClear1":
       MSTopSitesAdminClear1( );
    break;

    case "MSTopSitesAdminCheck":
       MSTopSitesAdminCheck( );
    break;

    case "MSTopSitesAdminCat":
       MSTopSitesAdminCat( );
    break;    

    case "MSTopSitesAdminEditSite":
       MSTopSitesAdminEditSite( $id );
    break;

    case "MSTopSitesAdminSaveSite":
       MSTopSitesAdminSaveSite( $uname, $sname, $url, $email, $buttonurl, $description, $cat );
    break;

    case "MSTopSitesAdminDeleteSite":
       MSTopSitesAdminDeleteSite( $id );
    break;

    case "MSTopSitesAdminDeleteSite1":
       MSTopSitesAdminDeleteSite1( $id );
    break;

    case "MSTopSitesAdminResetSite":
       MSTopSitesAdminResetSite( $id );
    break;

    case "MSTopSitesAdminResetSite1":
       MSTopSitesAdminResetSite1( $id );
    break;

    case "MSTopSitesAdminDeleteCat":
       MSTopSitesAdminDeleteCat( $cat );
    break;

    case "MSTopSitesAdminDeleteCat1":
       MSTopSitesAdminDeleteCat1( $cat );
    break;

    case "MSTopSitesAdminModCat":
       MSTopSitesAdminModCat( $cat );
    break;

    case "MSTopSitesAdminModCat1":
       MSTopSitesAdminModCat1( $ncat, $cat );
    break;    

    default:
       MSTopSitesAdmin( );
}

} else { echo "Access Denied\n"; }

?>
