<?php

/************************************************************************************/
/*                                                                                  */
/* Maty Scripts Top-Sites for PHP-Nuke 6.5                                          */
/* v1.0  25-03-2003                                                                 */
/*                                                                                  */
/* Copyright  2002 by: Maty Scripts (webmaster@matyscripts.com)                    */
/* http://www.matyscripts.com                                                       */
/*                                                                                  */
/* This program is free software. You can redistribute it and/or modify             */
/* it under the terms of the GNU General Public License as published by             */
/* the Free Software Foundation; either version 2 of the License.                   */
/*                                                                                  */
/************************************************************************************/

$index = 1;
$module_name = basename( dirname( __FILE__ ) );

if (!eregi("modules.php", $_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

if( isset( $newlang ) ) {
   include( "modules/$module_name/language/lang-$newlang.php" );
   $language = $newlang;
} elseif ( isset( $lang ) ) {
   include( "modules/$module_name/language/lang-$lang.php" );
   $language = $lang;
} else {
   include( "modules/$module_name/language/lang-$language.php" );
}

require_once( "mainfile.php" );
require_once( "modules/$module_name/class.mstopsites.php" );
/******************************************************************************/
/* FUNCTION: MSTopSitesStats()                                                */
/* Show Stat for selected memberID                                            */
/******************************************************************************/
function MSTopSitesStats( $id )
{
   global $module_name, $db, $prefix, $bgcolor1, $bgcolor2;
   $msts = new mstopsites();

   include( "header.php" );
   // Plot Header
   $msts->MSTopSitesPlotHeader();
   // Plot Menu
   echo "".$msts->MSTopSitesPlotMenu();
      
   $result = $db->sql_query( "SELECT memberid FROM $prefix"._mstopsites." WHERE memberid = '$id'" );
   if( !$result ) { echo "<center><font color=\"FB0000\"><h3>"._MSTS_NOID."</font></h3></center>\n"; }
   else {
      $result = $db->sql_query( "SELECT uname, sitename, url, buttonurl, description, category, regdate, startdate, daysold, hitsin, hitsout, hitstotal, hitstoday, rating, rank FROM $prefix"._mstopsites." WHERE memberid = '$id'" );
      list( $uname, $sitename, $url, $buttonurl, $description, $category, $regdate, $startdate, $daysold, $hitsin, $hitsout, $hitstotal, $hitstoday, $rating, $rank ) = $db->sql_fetchrow( $result ); 
      $sitename = htmlspecialchars( $sitename );
      $buttonurl = htmlspecialchars( $buttonurl );
      $description = htmlspecialchars( $description );
      $url = htmlspecialchars( $url );
      $suname = "<A HREF=\"modules.php?name=Your_Account&amp;op=userinfo&amp;username=$uname\">$uname</a>";
            
      echo "<center><br>\n";
      echo "<table border=\"1\" cellpadding=\"2\" cellspacing=\"0\" width=\"70%\" bgcolor=$bgcolor2 class=\"content\">\n";
      echo "<tr class=\"title\">\n";
      echo "<td width=\"100%\" bgcolor=$bgcolor2>\n";
      echo "<p align=\"center\">< "._MSTS_STATSID.": $sitename ?></td>\n";
      echo "</tr>\n";
      echo "<tr>\n";
      echo "<td width=\"100%\" bgcolor=$bgcolor1>\n";
      echo "<br><center><b>$sitename</b></center><br>\n";

      if( $buttonurl != "" ) { echo "<center><img src=\"$buttonurl\" border=\"0\" width=\"88\" height=\"31\"></center>\n"; }
      else { echo "<center><b>[ NO BUTTON ]</b></center><br>\n"; }

      echo "<center><a href=\"$url\" target=\"_blank\">$url</a></center><br>\n";
      echo "<center><b>"._MSTS_CATEGORY."</b><br> $category</center><br>\n";
      echo "<center><b>"._MSTS_DESCRIPTION."</b><br> $description</center><br><br>\n";

      echo "<div align=\"center\">\n";
      echo "<table border=\"1\" cellpadding=\"2\" cellspacing=\"0\" width=\"70%\" class=\"content\">\n";
      echo "<tr>\n";
      echo "<td width=\"100%\" colspan=\"2\" bgcolor=$bgcolor2><b><center>"._MSTS_UNAME." - $suname</b></center></td>\n";
      echo "</tr>\n";      
      echo "<tr>\n";
      echo "<td width=\"60%\" bgcolor=$bgcolor1><b>"._MSTS_RANK."</b></td>\n";
      echo "<td width=\"40%\" bgcolor=$bgcolor1><b>$rank</b></td>\n";
      echo "</tr>\n";
      echo "<tr>\n";
      echo "<td width=\"60%\"><b>"._MSTS_REGDATE."</b></td>\n";
      echo "<td width=\"40%\">".substr( $regdate, 0, 10 )."</td>\n";
      echo "</tr>\n";
      echo "<tr>\n";
      echo "<td width=\"60%\"><b>"._MSTS_STARTDATE."</b></td>\n";
      echo "<td width=\"40%\">".substr( $startdate, 0, 10 )."</td>\n";
      echo "</tr>\n";      
      echo "<tr>\n";
      echo "<td width=\"60%\"><b>"._MSTS_HITSIN."</b></td>\n";
      echo "<td width=\"40%\">$hitsin</td>\n";
      echo "</tr>\n";
      echo "<tr>\n";
      echo "<td width=\"60%\"><b>"._MSTS_HITSOUT."</b></td>\n";
      echo "<td width=\"40%\">$hitsout</td>\n";
      echo "</tr>\n";
      echo "<tr>\n";
      echo "<td width=\"60%\"><b>"._MSTS_HITSTODAY."</b></td>\n";
      echo "<td width=\"40%\">$hitstoday</td>\n";
      echo "</tr>\n";
      echo "<tr>\n";
      echo "<td width=\"60%\"><b>"._MSTS_TOTALHITS."</b></td>\n";
      echo "<td width=\"40%\">$hitstotal</td>\n";
      echo "</tr>\n";
      if( $hitsin != 0 ) { $raverage = round( $rating / $hitsin, 2 ); } else { $raverage = 0; }
      echo "<tr>\n";
      echo "<td width=\"60%\"><b>"._MSTS_RATING."</b></td>\n";
      echo "<td width=\"40%\">$raverage</td>\n";
      echo "</tr>\n";
      if( $daysold != 0 ) { $average = round( $hitstotal / $daysold, 2 ); } else { $average = $hitstotal; }
      echo "<tr>\n";
      echo "<td width=\"60%\"><b>"._MSTS_AVERAGE."</b></td>\n";
      echo "<td width=\"40%\">$average</td>\n";
      echo "</tr>\n";
      echo "</table></div>\n";
      echo "<br><br><i><center>"._MSTS_CHEAT1."</center><center><a href=\"modules.php?name=$module_name&file=stats&amp;op=MSTopSitesCheat&amp;id=$id&amp;sname=$sitename&amp;surl=$url\">"._MSTS_CHEAT2."</a></center></i>\n";
      echo "<br><br><center><a href=\"javascript:history.go(-1)\">"._MSTS_BACK."</a></center></td>\n";
      echo "</tr></table></div>\n";
   }
   // Plot footer    
   $msts->MSTopSitesPlotFooter();   
   include( "footer.php" );
}

/******************************************************************************/
/* FUNCTION: MSTopSitesCheat()                                                */
/* Send Mail to Webmaster: Somebody thinks that 'somebody' is cheating        */
/******************************************************************************/
function MSTopSitesCheat( $id, $sname, $surl )
{
   global $module_name, $bgcolor1, $bgcolor2;
   $msts = new mstopsites();

   include( "header.php" );
   // Plot Header
   $msts->MSTopSitesPlotHeader();
   // Plot Menu
   echo "".$msts->MSTopSitesPlotMenu();
   
   // Check if user is registered   
   $tuser = $msts->MSTopSitesTypeOfUser();  // 0 = Guest - 1 = Site Member - 2 = Site + Top-Site member | uname | memberid
   $tuser = explode( "|",$tuser );
   if( $tuser[ 0 ] == 0 ) { echo "".$msts->MSTopSitesMessageScreen( _MSTS_CHEAT3, _MSTS_NOTREGISTERED ); }
   else if( $tuser[ 0 ] == 1 ) { echo "".$msts->MSTopSitesMessageScreen( _MSTS_CHEAT3, "Hi <font color=\"#FF0000\">".$tuser[ 1 ]."</font>, "._MSTS_ADDSITEFIRST ); }
   else {
      echo "<center><br>\n";
      echo "<table border=\"1\" cellpadding=\"2\" cellspacing=\"0\" width=\"50%\" bgcolor=$bgcolor2 class=\"content\">\n";
      echo "<tr class=\"title\">\n";
      echo "<td width=\"100%\" bgcolor=$bgcolor2><p align=\"center\">< "._MSTS_CHEAT3." ?></td>\n";
      echo "</tr>\n";
      echo "<tr>\n";
      echo "<td width=\"100%\" bgcolor=$bgcolor1>"._MSTS_CHEAT4.":<br><br>\n";
      echo "<form action=\"modules.php?name=$module_name&file=stats\" method=\"post\">\n";
      echo ""._MSTS_CHEAT6.":&nbsp;<b><font color=\"#FF0000\">".$tuser[ 1 ]."</font></b><br><br>\n";
      echo ""._MSTS_CHEAT5.":&nbsp;<b><font color=\"#FF0000\">$sname - $surl</font></b><br><br>\n";
      echo ""._MSTS_CHEAT7.":<br><textarea rows=\"7\" name=\"why\" cols=\"32\" value=\"$why\"></textarea><br>\n";
      echo "<input type=\"hidden\" name=\"uname\" value=\"".$tuser[ 1 ]."\">\n";
      echo "<input type=\"hidden\" name=\"id\" value=\"$id\">\n";
      echo "<input type=\"hidden\" name=\"sname\" value=\"$sname\">\n";
      echo "<input type=\"hidden\" name=\"surl\" value=\"$surl\">\n";
      echo "<input type=\"hidden\" name=\"op\" value=\"MSTopSitesMailCheater\">\n";
      echo "<input type=\"submit\" value=\""._MSTS_CHEAT3."\">\n";
      echo "</form></td>\n";
      echo "</tr>\n";
      echo "</table>\n";
      echo "</center>\n";
   }
   // Plot footer
   $msts->MSTopSitesPlotFooter();
   include( "footer.php" );
}

/******************************************************************************/
/* FUNCTION: MSTopSitesMailCheater()                                          */
/* Send Mail to Webmaster: Somebody thinks that 'somebody' is cheating        */
/******************************************************************************/
function MSTopSitesMailCheater( $uname, $id, $sname, $surl, $why )
{
   global $module_name, $db, $prefix, $bgcolor1, $bgcolor2;
   $msts = new mstopsites();

   include( "header.php" );
   // Plot Header
   $msts->MSTopSitesPlotHeader();
   // Plot Menu
   echo "".$msts->MSTopSitesPlotMenu();

   if( $uname == "" || $id == "" || $why == "" ) {
      $msts->MSTopSitesMessageScreen( _MSTS_CHEAT3, _MSTS_ALLFIELDS );
   }
   else {
      $result = $db->sql_query( "SELECT url, email FROM $prefix"._mstopsites." WHERE uname = '$uname'" );
      list( $url, $email ) = $db->sql_fetchrow( $result ); 
      $result = $db->sql_query( "SELECT webmaster_email, webmaster_url FROM $prefix"._mstopsites_cnf." WHERE id = '1'" );
      list( $webmaster_email, $webmaster_url ) = $db->sql_fetchrow( $result ); 
   
      $message1 = "Dear webmaster of $url,\n<br>\n<br>Thanks for letting us know that you think the website with ID: [ $id - $sname - $surl ] is cheating our TopSite; we thank you very much for it !!!\n<br>\n<br>Greetz,\n<br>Webmaster: $webmaster_url\n";
      mail( "$email", "Thanks for reporting !!!","$message1","From: Thanks for your report !!!<$webmaster_email>\nContent-Type: text/html; charset=iso-8859-1");
      $message2 = "Dear webmaster,\n<br>\n<br>The webmaster of <b><a href=\"$url\" target=\"_blank\">$url</a></b> thinks that somebody's cheating your TopSite, the ID of this possible cheater is <b>[ $id - $sname - $surl ]</b> His/her email address is: $email\n<br>\n<br>This is the reason why he/she thinks this site is cheating: <hr>$why<hr>Greetz Auto email bot :-)\n";
      mail("$webmaster_email","Cheater Report","$message2","From: Cheater Report<$webmaster_email>\nContent-Type: text/html; charset=iso-8859-1");

      echo "<center><br>\n";
      echo "<table border=\"1\" cellpadding=\"2\" cellspacing=\"0\" width=\"50%\" bgcolor=$bgcolor2 class=\"content\">\n";
      echo "<tr class=\"title\">\n";
      echo "<td width=\"100%\" bgcolor=$bgcolor2><p align=\"center\">< "._MSTS_CHEAT3." ?></td>\n";
      echo "</tr>\n";
      echo "<tr>\n";
      echo "<td width=\"100%\" bgcolor=$bgcolor1>"._MSTS_CHEAT8."<br><br>\n";
      echo "<center><a href=\"modules.php?name=$module_name&file=index\">"._MSTS_MAIN."</a></center></td>\n";
      echo "</tr>\n";
      echo "</table>\n";
      echo "</center>\n";
   }
   // Plot footer
   $msts->MSTopSitesPlotFooter();
   include( "footer.php" );
}
/***************************************************/
/****************** PROGRAM START ******************/
/***************************************************/
switch ( $op )
{
    case "MSTopSitesStats":
       MSTopSitesStats( $id );
    break;

    case "MSTopSitesCheat":
       MSTopSitesCheat( $id, $sname, $surl );
    break;

    case "MSTopSitesMailCheater":
       MSTopSitesMailCheater( $uname, $id, $sname, $surl, $why );
    break;    

    default:
       MSTopSitesStats( $id );
}


?>
