<?php

/************************************************************************************/
/*                                                                                  */
/* Maty Scripts Top-Sites for PHP-Nuke 6.5                                          */
/* v1.0  25-03-2003                                                                 */
/*                                                                                  */
/* Copyright  2002 by: Maty Scripts (webmaster@matyscripts.com)                    */
/* http://www.matyscripts.com                                                       */
/*                                                                                  */
/* This program is free software. You can redistribute it and/or modify             */
/* it under the terms of the GNU General Public License as published by             */
/* the Free Software Foundation; either version 2 of the License.                   */
/*                                                                                  */
/************************************************************************************/

class mstopsites 
{ 
   var $ResetInDays = 0;
   var $ResetDays = 0;
   var $AReset = 0;
   
   /******************************************************/
   /*                                                    */
   /* Constructor function mstopsites                    */
   /*                                                    */
   /******************************************************/
   function mstopsites()
   {
      global $prefix, $db;
      
      // Routine for automatic reset of statistics
      $result = $db->sql_query( "SELECT allow_reset, nbrdays, begindate FROM $prefix"._mstopsites_cnf." WHERE id = '1'" );
      list( $allow_reset, $nbrdays, $begindate ) = $db->sql_fetchrow( $result );
      if( $allow_reset )
      {
	     $this->AReset = 1;
	     $this->ResetDays = $nbrdays;
         $begindate = $begindate. " 00:00:00";
         $daysold = $this->MSTopSitesDaysOld( $begindate );
         $this->ResetInDays = $nbrdays - ( $daysold % $this->ResetDays );
         if( ( $daysold % $this->ResetDays ) != 0 ) $this->MSTopSitesSetResetFlag( "1" );
         $resetflag = $this->MSTopSitesGetResetFlag();
         
         if( ( ( $daysold % $this->ResetDays ) == 0 ) AND ( $resetflag == 1 ) )
         {
            // Reset all Members in Database
            $this->MSTopSitesSetResetFlag( "0" );
            $today = date( "Y-m-d G:i:s" );
            $result = $db->sql_query( "SELECT memberid FROM $prefix"._mstopsites );
            while( list( $memberid ) = $db->sql_fetchrow( $result ) ) {
               $result1 = $db->sql_query( "UPDATE $prefix"._mstopsites." SET startdate = '$today', curdate = '$today', daysold = '0', hitsin = '0', hitsout = '0', hitstotal = '0', hitstoday = '0', rating = '0' WHERE memberid = '$memberid'" );
            }
            // Reset the IP Table
            $result = $db->sql_query( "DELETE FROM $prefix"._mstopsites_ip );
         }
      }
   }

   /******************************************************************************/
   /* FUNCTION: MSTopSitesSetResetFlag( $rf )                                    */
   /* Set the reset flag to 0 or 1                                               */
   /******************************************************************************/   
   function MSTopSitesSetResetFlag( $rf )
   {
      global $prefix, $db;
      $result = $db->sql_query( "UPDATE $prefix"._mstopsites_cnf." SET  resetflag = '$rf' WHERE id = '1'" );
   }

   /******************************************************************************/
   /* FUNCTION: MSTopSitesGetResetFlag()                                         */
   /* Get the status of the reset flag                                           */
   /******************************************************************************/   
   function MSTopSitesGetResetFlag()
   {
      global $prefix, $db;
      $result = $db->sql_query( "SELECT resetflag FROM $prefix"._mstopsites_cnf." WHERE id = '1'" );
      list( $resetflag ) = $db->sql_fetchrow( $result );
      return( $resetflag );
   }

   /******************************************************************************/
   /* FUNCTION: MSTopSitesGetRanking()                                           */
   /* Return type of ranking                                                     */
   /******************************************************************************/   
   function MSTopSitesGetRanking()
   {
      global $prefix, $db;
      $result = $db->sql_query( "SELECT ranking FROM $prefix"._mstopsites_cnf." WHERE id = '1'" );
      list( $ranking ) = $db->sql_fetchrow( $result );
      return( $ranking );
   }   
   
   /******************************************************************************/
   /* FUNCTION: MSTopSitesGetIp()                                                */
   /* Return users real IP address                                               */
   /******************************************************************************/   
   function MSTopSitesGetIp()
   {
      // Get useful vars
      if( isset( $_SERVER ) ) {
         $client_ip = $_SERVER['HTTP_CLIENT_IP'];
         $x_forwarded_for = $_SERVER['HTTP_X_FORWARDED_FOR'];
         $remote_addr = $_SERVER['REMOTE_ADDR'];
      }
      else {
         $client_ip = getenv( 'HTTP_CLIENT_IP' );
         $x_forwarded_for = getenv( 'HTTP_X_FORWARDED_FOR' );
         $remote_addr = getenv( 'REMOTE_ADDR' );
      }
      
      // Then the script itself
      if( !empty( $client_ip ) ) {
         $ip_expl = explode( '.', $client_ip );
         $referer = explode( '.', $remote_addr );
         if( $referer[0] != $ip_expl[0] ) {
            $ip = array_reverse( $ip_expl );
            $real_ip = implode( '.', $ip );
         }
         else {
            $real_ip = $client_ip;
         };
      }
      elseif( !empty( $x_forwarded_for ) ) {
         if( strstr( $x_forwarded_for, ',' ) ) {
            $ip_expl = explode( ',', $x_forwarded_for );
            $real_ip = end( $ip_expl );
         }
         else {
            $real_ip = $x_forwarded_for;
         };
      }
      else {
         $real_ip = $remote_addr;
      };
      return $real_ip;
   }

   /******************************************************************************/
   /* FUNCTION: MSTopSitesDaysOld( $enterdate )                                  */
   /* Return how many days ago a user was on-line                                */
   /******************************************************************************/
   function MSTopSitesDaysOld( $enterdate )
   {
	  $enterdate = substr( $enterdate, 0, 10 ) . " 00:00:00";
      $date_secs = strtotime( $enterdate );
      // get the value of right now
      $now = time();
      // compute the difference
      $timediff = $date_secs - $now;
      //get the int val of the days passed
      $dayspassed = intval( abs( ( ( ( $timediff / 60 ) / 60 ) / 24 ) ) );
      return( $dayspassed + 1 );
   }

   /******************************************************************************/
   /* FUNCTION: MSTopSitesCDate( $datetime )                                     */
   /* Converting mySQL timestamp to PHP timestamp                                */
   /******************************************************************************/
   function MSTopSitesCDate( $datetime )
   {
      $yr  = substr( $datetime, 0,  4 );
      $mon = substr( $datetime, 5,  2 );
      $day = substr( $datetime, 8,  2 );
      $hr  = substr( $datetime, 11, 2 );
      $min = substr( $datetime, 14, 2 );
      return( $yr.$mon.$day ); 
   }

   /******************************************************************************/
   /* FUNCTION: MSTopSitesIPCheck( $id )                                         */
   /* If IP checking enabled, check if vote is valid                             */
   /******************************************************************************/
   function MSTopSitesIPCheck( $id )
   {
      global $db, $prefix;
      
      // Determine IP
      $ip = $this->MSTopSitesGetIp();
      // Check if voters IP are logged
      $validvote = 1;
      $result = $db->sql_query( "SELECT logip FROM $prefix"._mstopsites_cnf." WHERE id = '1'" );
      list( $logip ) = $db->sql_fetchrow( $result );
      // When they are logged, check if user with this IP already voted for this site ID
      if( $logip ) {
         $votedalready = $db->sql_numrows( $db->sql_query( "SELECT ip, memberid FROM $prefix"._mstopsites_ip." WHERE ip='$ip' AND memberid='$id'" ) );
         if( $votedalready == 0 ) {
            // Set IP + memberid in IP table to indicate the voters vote
            $result = $db->sql_query( "insert into $prefix"._mstopsites_ip." ( ip, memberid ) values ( '$ip', '$id' )" );
         }
         else $validvote = 0;    
      }
      return( $validvote );
   }

   /******************************************************************************/
   /* FUNCTION: MSTopPlotMenu( )                                                 */
   /* Plot the Top-Sites Menu                                                    */
   /******************************************************************************/
   function MSTopSitesPlotMenu( )
   {
	  global $admin, $module_name;
	  
      $menubuf  = "<center> [ <a href=\"modules.php?name=$module_name&file=index\">"._MSTS_MAIN."</a>&nbsp;&nbsp;\n";
      $menubuf .= "<a href=\"modules.php?name=$module_name&file=join\">"._MSTS_ADDSITE."</a>&nbsp;&nbsp;\n";
      $menubuf .= "<a href=\"modules.php?name=$module_name&file=edit\">"._MSTS_EDITSITE."</a>&nbsp;&nbsp;\n";
      $menubuf .= "<a href=\"modules.php?name=$module_name&file=lostcode\">"._MSTS_LOSTCODE."</a>&nbsp;&nbsp;\n";
      $menubuf .= "<a href=\"modules.php?name=$module_name&file=rules\">"._MSTS_RULES."</a>\n";      
      if( is_admin( $admin ) ) { $menubuf .= "&nbsp;&nbsp;&nbsp;<a href=\"modules.php?name=$module_name&file=mstopsitesadmin\">"._MSTS_ADMIN."</a> ]</center><br>\n"; }
      else { $menubuf .= " ]</center><br>\n"; }
      return( $menubuf );
   }
   
   /******************************************************************************/
   /* FUNCTION: MSTopSitesPlotHeader()                                           */
   /******************************************************************************/
   function MSTopSitesPlotHeader( )
   {
      global $db, $prefix, $module_name;
  
      $result = $db->sql_query( "select topsite_name from $prefix"._mstopsites_cnf." where id='1'" );
      list( $topsite_name ) = $db->sql_fetchrow( $result );
      echo "<center><img src=\"modules/$module_name/images/logo.gif\" border=\"0\"></center><center><font color=\"FB0000\"><h3>".$topsite_name."</font></h3></center>\n";
   }

   /******************************************************************************/
   /* FUNCTION: MSTopSitesPlotFooter()                                           */
   /******************************************************************************/
   function MSTopSitesPlotFooter()
   {
      global $db, $prefix;
  
      echo "<br><br>\n";
      // Tot Menbers
      $totmembers = $db->sql_numrows( $db->sql_query( "select * from $prefix"._mstopsites ) );
      // Total Votes
      $totvotes = 0;
      $result = $db->sql_query( "select hitstotal from $prefix"._mstopsites );
      while( list( $hitstotal ) = $db->sql_fetchrow( $result ) ) { $totvotes = $totvotes + $hitstotal; }
      
      $totmembersonline = 0;
      $result = $db->sql_query( "select uname from $prefix"._session." where guest=0" ); 
      while( list( $uname ) = $db->sql_fetchrow( $result ) ) {
         $result1 = $db->sql_query( "select uname from $prefix"._mstopsites." where uname='$uname'" );
         while( list( $uname ) = $db->sql_fetchrow( $result1 ) ) { $totmembersonline += 1; }
      }
      echo "<center><font class=\"tiny\">"._MSTS_ADMINFS1." ".$totmembers." "._MSTS_ADMINFS2.", ".$totmembersonline." "._MSTS_ADMINFS0.", ".$totvotes." "._MSTS_ADMINFS3."</font></center>\n";
      if( $this->AReset ) echo "<center><font class=\"tiny\">"._MSTS_ADMINFS4." " . $this->ResetDays . " "._MSTS_ADMINFS5. " ".$this->ResetInDays . " "._MSTS_ADMINFS6."</font></center>\n";
      // Read Version Number
      $result = $db->sql_query( "select copyright, version from $prefix"._mstopsites_cnf." where id='1'" );
      list( $copyright, $version ) = $db->sql_fetchrow( $result );
      echo "<br><center><font class=\"tiny\"><b>".$version." - Based on DXT Top 1.0 Pro by <a href=\"http://www.digital-xtreme.net\" target=\"_blank\">DXT</a> - Nuked+ "._BY.": <a href=\"http://www.matyscripts.com\">".$copyright."</a></b></font></center>\n";
   }

   /****************************************************************************************/
   /* FUNCTION: MSTopSitesTypeOfUser()                                                     */
   /* Determine the type of user and username                                              */
   /* Return: 0 = Guest - 1 = Site Member - 2 = Site + Top-Site member | uname | memberid  */ 
   /****************************************************************************************/
   function MSTopSitesTypeOfUser()   
   {
      global $db, $prefix, $user_prefix, $user, $cookie;

      // Get User name
      cookiedecode( $user );
      $username = $cookie[1];   

      $usertype = 0;
      if( is_user( $user ) ) {
         $result = $db->sql_query( "SELECT uname FROM $prefix"._mstopsites." WHERE uname = '$username'" );
         if( $db->sql_numrows( $result ) != 0 ) {
            $result = $db->sql_query( "SELECT memberid, uname FROM $prefix"._mstopsites." WHERE uname = '$username'" );
            list( $memberid, $uname ) = $db->sql_fetchrow( $result );
            $usertype = 2;
         }
         else {
            $result = $db->sql_query( "SELECT username FROM $user_prefix"._users." WHERE username = '$username'" );
            list( $uname ) = $db->sql_fetchrow( $result );
	        $usertype = 1; $memberid = 0;
	     }
      }
      else { $usertype = 0; $uname = "Guest"; $memberid = 0; }
      return( "$usertype|$uname|$memberid" );
   }
   
   /******************************************************************************/
   /* FUNCTION: MSTopSitesMessageScreen()                                        */
   /* Plot a Message Screen                                                      */
   /******************************************************************************/
   function MSTopSitesMessageScreen( $mstitle, $message )
   {
	  global $bgcolor1, $bgcolor2;
	  
      $menubuf  = "<center><br>\n";
      $menubuf .= "<table border=\"1\" cellpadding=\"2\" cellspacing=\"0\" width=\"50%\" bgcolor=$bgcolor2 class=\"content\">\n";
      $menubuf .= "<tr class=\"title\">\n";
      $menubuf .= "<td width=\"100%\" bgcolor=$bgcolor2><p align=\"center\">< $mstitle ?></td>\n";
      $menubuf .= "</tr>\n";
      $menubuf .= "<tr>\n";
      $menubuf .= "<td width=\"100%\" bgcolor=$bgcolor1><center>".$message."</center><br><br>\n";
      $menubuf .= "<center><a href=\"javascript:history.go(-1)\">"._MSTS_BACK."</a></center></td>\n";
      $menubuf .= "</tr>\n";
      $menubuf .= "</table>\n";
      $menubuf .= "</center>\n";	   
      return( $menubuf );
   }  
   
   /******************************************************************************/
   /* FUNCTION: MSTopSitesConfirmationScreen()                                   */
   /* Plot a Message Screen                                                      */
   /******************************************************************************/
   function MSTopSitesConfirmationScreen( $mstitle, $message )
   {
	  global $module_name, $bgcolor1, $bgcolor2;
	  
      $menubuf  = "<center><br>\n";
      $menubuf .= "<table border=\"1\" cellpadding=\"2\" cellspacing=\"0\" width=\"50%\" bgcolor=$bgcolor2 class=\"content\">\n";
      $menubuf .= "<tr class=\"title\">\n";
      $menubuf .= "<td width=\"100%\" bgcolor=$bgcolor2><p align=\"center\">< $mstitle ?></td>\n";
      $menubuf .= "</tr>\n";
      $menubuf .= "<tr>\n";
      $menubuf .= "<td width=\"100%\" bgcolor=$bgcolor1><center>".$message."</center><br><br>\n";
      $menubuf .= "<center><a href=\"modules.php?name=$module_name&file=index\">"._MSTS_MAIN."</a></center></td>\n";      
      $menubuf .= "</tr>\n";
      $menubuf .= "</table>\n";
      $menubuf .= "</center>\n";	   
      return( $menubuf );
   }  
   
   
                             
} 

?> 