<?php

/************************************************************************************/
/*                                                                                  */
/* Maty Scripts Top-Sites for PHP-Nuke 6.5                                          */
/* v1.0  25-03-2003                                                                 */
/*                                                                                  */
/* Copyright  2002 by: Maty Scripts (webmaster@matyscripts.com)                    */
/* http://www.matyscripts.com                                                       */
/*                                                                                  */
/* This program is free software. You can redistribute it and/or modify             */
/* it under the terms of the GNU General Public License as published by             */
/* the Free Software Foundation; either version 2 of the License.                   */
/*                                                                                  */
/************************************************************************************/

$index = 1;
$module_name = basename( dirname( __FILE__ ) );

if (!eregi("modules.php", $_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

if( isset( $newlang ) ) {
   include( "modules/$module_name/language/lang-$newlang.php" );
   $language = $newlang;
} elseif ( isset( $lang ) ) {
   include( "modules/$module_name/language/lang-$lang.php" );
   $language = $lang;
} else {
   include( "modules/$module_name/language/lang-$language.php" );
}
require_once( "mainfile.php" );
require_once( "modules/$module_name/class.mstopsites.php" );
/******************************************************************************/
/* FUNCTION: MSTopSitesGeneral()                                              */
/*                                                                            */
/******************************************************************************/
function MSTopSitesGeneral( $cpage, $cat )
{
   global $module_name, $db, $prefix;
  
   include( "header.php" );
   
   // Display Table
   MSTopSitesDisplayTable( $cpage, $cat );
   
   include( "footer.php" );
} // END function MSTopSitesGeneral()

/******************************************************************************/
/* FUNCTION: MSTopSitesDisplayTable()                                         */
/* Display Table                                                              */
/******************************************************************************/
function MSTopSitesDisplayTable( $cpage, $cat )
{
   global $db, $prefix, $module_name, $bgcolor1, $bgcolor2;
   $msts = new mstopsites();
   
   // Plot Header
   $msts->MSTopSitesPlotHeader();
   // Bring Table up to date
   MSTopSitesUpdate();
   // Plot Menu
   echo "".$msts->MSTopSitesPlotMenu();

   // Count amount of rows (sites)    
   if( isset( $cat ) AND ( $cat != "" ) ) { $total = $db->sql_numrows( $db->sql_query( "select * from $prefix"._mstopsites." where category = '$cat'" ) ); }
   else { $total = $db->sql_numrows( $db->sql_query( "select * from $prefix"._mstopsites ) ); }
   
   // read some variables from database
   $result = $db->sql_query( "select img_visible, pp from $prefix"._mstopsites_cnf." where id='1'" );
   list( $img_visible, $pp ) = $db->sql_fetchrow( $result );

   // Calculate the Pages to display
   if(! isset( $cpage) ) {
      $page = 0;
      $prev = "<font class=\"inactive\"><< "._MSTS_PREVIOUS." $pp</font>";
   }
   else { $page = $cpage; }

   $startrow = $page * $pp;
   $endrow = $startrow + $pp - $page * $pp;
   $pages = $total / $pp;
   $pageplus = $page + 1;
   $pagemin = $page - 1;

   if( $page + 1 < $pages OR $pageplus == "$pages" ) { $next = "<a href=\"modules.php?name=$module_name&file=index&cpage=$pageplus&cat=$cat\">"._MSTS_NEXT." $pp >></a>"; }
   if( $page - 1 < $pages AND $page ) { $prev = "<a href=\"modules.php?name=$module_name&file=index&cpage=$pagemin&cat=$cat\"><< "._MSTS_PREVIOUS." $pp</a>"; }
   else { $prev = "<font class=\"inactive\"><< "._MSTS_PREVIOUS." $pp</font>"; }
   if( $pageplus > $pages ) { $next = "<font class=\"inactive\">"._MSTS_NEXT." $pp >></font>"; }   

   echo "<div align=\"center\">\n";
   echo "<br>\n$prev ][ $next<br>\n";
   echo "<table border=\"1\" cellpadding=\"2\" cellspacing=\"0\" width=\"95%\" bgcolor=$bgcolor2 class=\"content\">\n";
   echo "<tr class=\"title\">\n";
   echo "<td width=\"6%\" bgcolor=$bgcolor2><p align=\"center\"><img src=\"modules/$module_name/images/rank.gif\" ALT=\""._MSTS_RANK."\" border=\"0\"><img src=\"modules/$module_name/images/rank.gif\" ALT=\""._MSTS_RANK."\" border=\"0\"><img src=\"modules/$module_name/images/rank.gif\" ALT=\""._MSTS_RANK."\" border=\"0\"></td>\n";
   echo "<td width=\"55%\" bgcolor=$bgcolor2><p align=\"center\">"._MSTS_DESCRIPTION."</td>\n";
   echo "<td width=\"6%\" bgcolor=$bgcolor2><p align=\"center\">"._MSTS_HITSIN."</td>\n";
   echo "<td width=\"6%\" bgcolor=$bgcolor2><p align=\"center\">"._MSTS_HITSOUT."</td>\n";
   echo "<td width=\"8%\" bgcolor=$bgcolor2><p align=\"center\">"._MSTS_RATING."</td>\n";
   echo "<td width=\"8%\" bgcolor=$bgcolor2><p align=\"center\">"._MSTS_AVERAGE."</td>\n";
   echo "<td width=\"15%\" bgcolor=$bgcolor2><p align=\"center\"><img src=\"modules/$module_name/images/stats.gif\" ALT=\""._MSTS_STATISTICS."\" border=\"0\"></td>\n";
   echo "</tr>\n";

   if( isset( $cat ) AND ( $cat != "" ) ) {   
      if( $msts->MSTopSitesGetRanking() == 0 ) $result = $db->sql_query( "SELECT memberid, sitename, buttonurl, description, category, daysold, hitsin, hitsout, hitstotal, rating, rank FROM $prefix"._mstopsites." where category = '$cat' ORDER BY hitsin DESC, hitsout DESC, hitstotal DESC LIMIT $startrow,$endrow" );
      else $result = $db->sql_query( "SELECT memberid, sitename, buttonurl, description, category, daysold, hitsin, hitsout, hitstotal, rating, rank FROM $prefix"._mstopsites." where category = '$cat' ORDER BY hitstotal DESC, hitsin DESC, hitsout DESC LIMIT $startrow,$endrow" );
   }
   else {
      if( $msts->MSTopSitesGetRanking() == 0 ) $result = $db->sql_query( "SELECT memberid, sitename, buttonurl, description, category, daysold, hitsin, hitsout, hitstotal, rating, rank FROM $prefix"._mstopsites." ORDER BY hitsin DESC, hitsout DESC, hitstotal DESC LIMIT $startrow,$endrow" );
      else $result = $db->sql_query( "SELECT memberid, sitename, buttonurl, description, category, daysold, hitsin, hitsout, hitstotal, rating, rank FROM $prefix"._mstopsites." ORDER BY hitstotal DESC, hitsin DESC, hitsout DESC LIMIT $startrow,$endrow" );
   }
   while( list( $memberid, $sitename, $buttonurl, $description, $category, $daysold, $hitsin, $hitsout, $hitstotal, $rating, $rank ) = $db->sql_fetchrow( $result ) ) {
      $sitename = htmlspecialchars( $sitename );
      $buttonurl = htmlspecialchars( $buttonurl );
      $description = htmlspecialchars( $description );
      if( $daysold != 0 ) { $average = round( $hitstotal / $daysold, 2 ); } else { $average = $hitstotal; }
      if( $hitsin != 0 ) { $raverage = round( $rating / $hitsin, 2 ); } else { $raverage = 0; }
      $ratingpic = "<img src=\"modules/$module_name/images/rating" . round( $raverage, 0 ) . ".jpg\" ALT=\""._MSTS_RATING."\" border=\"0\">\n";
      
      echo "<tr>\n";
      echo "<td width=\"6%\" bgcolor=$bgcolor1><p align=\"center\">$rank</td>\n";
      echo "<td width=\"55%\" bgcolor=$bgcolor1><p align=\"center\"><b><a href=\"modules.php?name=$module_name&file=out&id=$memberid\" target=\"_blank\"> $sitename</b></a>\n";
      if( ( $buttonurl != "" ) AND ( $rank <= $img_visible ) ) { echo "<br><a href=\"modules.php?name=$module_name&file=out&id=$memberid\" target=\"_blank\"><img src=\"$buttonurl\" width=\"88\" height=\"31\" border=\"0\"></a>"; }
      $description = wordwrap( $description, 75, "\n", 1 );
      echo "<br><br><b>"._MSTS_CATEGORY.":</b> <a href=\"modules.php?name=$module_name&file=index&cat=$category\"> $category</a>\n";
      echo "<br>$description</td>\n";
      echo "<td width=\"6%\" bgcolor=$bgcolor1><p align=\"center\">$hitsin</td>\n";
      echo "<td width=\"6%\" bgcolor=$bgcolor1><p align=\"center\">$hitsout</td>\n";
      echo "<td width=\"8%\" bgcolor=$bgcolor1><p align=\"center\">$raverage<br>$ratingpic</td>\n";
      echo "<td width=\"8%\" bgcolor=$bgcolor1><p align=\"center\">$average</td>\n";
      echo "<td width=\"15%\" bgcolor=$bgcolor1><p align=\"center\">[<a href=\"modules.php?name=$module_name&file=stats&id=$memberid\">Stats</a>]</td>\n";
      echo "</tr>\n";
      $nrank = $rank;
   } 
   $a = $nrank - 1;
   $b = $pp * ( $page + 1 );
   for( $c = $b - $a; $c > 0; $c-- ) {
      echo "<tr>\n";
      echo "<td width=\"6%\" bgcolor=$bgcolor1><p align=\"center\">-</td>\n";
      echo "<td width=\"55%\" bgcolor=$bgcolor1><p align=\"center\"><a href=\"modules.php?name=$module_name&file=join\">**- "._MSTS_YOURSITE." -**</a></td>\n";
      echo "<td width=\"6%\" bgcolor=$bgcolor1><p align=\"center\">-</td>\n";
      echo "<td width=\"6%\" bgcolor=$bgcolor1><p align=\"center\">-</td>\n";
      echo "<td width=\"8%\" bgcolor=$bgcolor1><p align=\"center\">-</td>\n";
      echo "<td width=\"8%\" bgcolor=$bgcolor1><p align=\"center\">-</td>\n";      
      echo "<td width=\"15%\" bgcolor=$bgcolor1><p align=\"center\">-</td>\n";
      echo "</tr>\n";
   }        
   echo "</table><br>\n$prev ][ $next<br>\n</div>\n";
  
   // Plot footer    
   $msts->MSTopSitesPlotFooter();
}

/******************************************************************************/
/* FUNCTION: MSTopSitesUpdate( )                                              */
/* Bring the table up to date !                                               */
/******************************************************************************/
function MSTopSitesUpdate( )
{
   global $db, $prefix, $module_name;
   $msts = new mstopsites();
   
   $i = 1;
   
   if( $msts->MSTopSitesGetRanking() == 0 ) $result = $db->sql_query( "SELECT memberid, startdate, curdate FROM $prefix"._mstopsites." ORDER BY hitsin DESC, hitsout DESC, hitstotal DESC" );
   else $result = $db->sql_query( "SELECT memberid, startdate, curdate FROM $prefix"._mstopsites." ORDER BY hitstotal DESC, hitsin DESC, hitsout DESC" );
   while( list( $memberid, $startdate, $curdate ) = $db->sql_fetchrow( $result ) ) {
      $today   = date( "Y-m-d G:i:s" );
      $newdate  = $msts->MSTopSitesCDate( $today );
      $olddate  = $msts->MSTopSitesCDate( $curdate );
      if( $newdate != $olddate ) { $result1 = $db->sql_query( "UPDATE $prefix"._mstopsites." SET hitstoday = 0 WHERE memberid = '$memberid'" ); }
      $daysold = $msts->MSTopSitesDaysOld( $startdate );
      $result1 = $db->sql_query( "UPDATE $prefix"._mstopsites." SET curdate = '$today', daysold = '$daysold', rank = '$i' WHERE memberid = '$memberid'" );
      if ( !$result1 ) echo "ERROR<br>";
      $i++;
   }	
}

/***************************************************/
/****************** PROGRAM START ******************/
/***************************************************/
switch ( $op )
{
    case "MSTopSitesGeneral":
       MSTopSitesGeneral( $cpage, $cat );
    break;

    case "MSTopSitesUpdate":
       MSTopSitesUpdate( );
    break;

    case "MSTopSitesDisplayTable":
       MSTopSitesDisplayTable( $cpage, $cat );
    break;

    default:
       MSTopSitesGeneral( $cpage, $cat );
}


?>

