<?php

/************************************************************************/
/* PHP-NUKE: Web Portal System                                          */
/* ===========================                                          */
/*                                                                      */
/* Copyright (c) 2002 by Francisco Burzi                                */
/* http://www.phpnuke.org                                               */
/*                                                                      */
/* IP Tracking                                                          */
/* =========================================================            */
/* Copyright (c) 2003 by Scott Rubin - phpnuke id: scottr               */
/* http://www.ierealtor.com (scottr2@earthlink.net)                     */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

if (!eregi("modules.php", $_SERVER['PHP_SELF'])) {
    die ("You can't access this file directly...");
}

require_once("mainfile.php");
$module_name = basename(dirname(__FILE__));
get_lang($module_name);
$pagetitle = "- "._IPTRACKING."";
if(is_user($user)) {
    if($cookie[9]=="") $cookie[9]=$Default_Theme;
    if(!$file=@opendir("themes/$cookie[9]")) {
	$ThemeSel = $Default_Theme;
    } else {
	$ThemeSel = $cookie[9];
    }
} else {
    $ThemeSel = $Default_Theme;
}

$now = date("d-m-Y");
$dot = explode ("-",$now);
$nowdate = $dot[0];
$nowmonth = $dot[1];
$nowyear = $dot[2];

function IP() {
    global $hlpfile,$nowyear,$nowmonth,$nowdate,$nowhour, $sitename, $startdate, $prefix, $dbi, $now, $numip, $pagenum, $show_hits, $Version_Num;
    $result = sql_query("select count from ".$prefix."_counter order by type desc", $dbi);
    list($total) = sql_fetch_row($result, $dbi);
    include ("header.php");
    title("$sitename "._IPTRACKING."");
    OpenTable();
    OpenTable();
    echo "<center><font class=\"option\"><b>$sitename "._IPTRACKING."</b></font><br>";
	echo "<br>"._WERECEIVED." <b>$total</b> "._PAGESVIEWS." $startdate<br>"._TODAYIS.": $now[1]/$now[0]/$now[2]<br><br>";
    echo "</center>";
    CloseTable();
    echo "<br><br>";
    showIPStats();
    echo "<br><br>";
    CloseTable();
	if($show_hits==1) { 
	    $filter="where username is not null";
	} elseif($show_hits==2) { 
	    $filter="where username is null";
	}
    $res = sql_query("select username, ip_address, hostname, max(date_time), count(*) "
	                  ."from ".$prefix."_iptracking $filter group by 1,2,3",$dbi);
    $numips = sql_num_rows($res, $dbi);
    $res = sql_query("select * from ".$prefix."_iptracking", $dbi);
    $numhits = sql_num_rows($res, $dbi);
    $numpages = ceil($numips / $numip);
    if ($numpages > 1) {
		echo "<br>";
		OpenTable();
		echo "<center>";
		echo "$numips "._IPADDRESSES." ($numhits "._HITS.", $numpages "._PAGES.", $numip "._PERPAGE.")<br>" ;
		# START Left Arrow
		if ($pagenum > 1) {
			$prevpage = $pagenum - 1 ;
			if(file_exists("images/download/left.gif")) { 
				$leftarrow = "images/download/left.gif" ;  # 5.x
			} else {
				$leftarrow = "images/left.gif" ;           # 6.x
			}
			echo "<a href=\"modules.php?name=IP_Tracking&amp;op=IP&amp;pagenum=$prevpage\">";
			echo "<img src=\"$leftarrow\" align=\"absmiddle\" border=\"0\" hspace=\"10\"></a>";
		}
		# END Left Arrow
		# START Page Numbers
		echo "[ " ;
		for ($i=1; $i < $numpages+1; $i++) {
			if ($i == $pagenum) {
				echo "$i";
			} else {
				echo "<a href=\"modules.php?name=IP_Tracking&amp;op=IP&amp;pagenum=$i\">$i</a>";
			}
			if ($i < $numpages) { echo " | "; } else { echo " ]"; }
		}
		# END Page Numbers
		# START Right Arrow
		if ($pagenum < $numpages) {
			$nextpage = $pagenum + 1 ;
			if(file_exists("images/download/right.gif")) { 
				$rightarrow = "images/download/right.gif" ;  # 5.x
			} else {
				$rightarrow = "images/right.gif" ;           # 6.x
			}
			echo "<a href=\"modules.php?name=IP_Tracking&amp;op=IP&amp;pagenum=$nextpage\">";
			echo "<img src=\"$rightarrow\" align=\"absmiddle\" border=\"0\" hspace=\"10\"></a>";
		}
		# END Right Arrow
		echo "</center>";
		CloseTable();
	}
	# this is automatic for 6.0+
	if($Version_Num < 6.0) {
		echo "<div align=\"right\"><a href=\"javascript:openwindow()\">IP Tracking &copy;</a></div>";
		echo "<script type=\"text/javascript\">\n";
		echo "<!--\n";
		echo "function openwindow(){\n";
		echo "	window.open (\"modules/IP_Tracking/copyright.php\",\"Copyright\",\"toolbar=no,location=no,directories=no,status=no,scrollbars=yes,resizable=no,copyhistory=no,width=400,height=200\");\n";
		echo "}\n";
		echo "//-->\n";
		echo "</SCRIPT>\n\n";
	}
	include ("footer.php");
}

function showIPStats(){
    global $admin,$prefix,$bgcolor1,$bgcolor2,$dbi, $ThemeSel;
	global $trackip, $numip, $pagenum, $hide_ipseg, $hide_host, $members_see_iphost, $ipmaskchar, $user, $orderby, $orderdir;
	global $show_hits, $members_see_users, $Version_Num;
    $l_size = getimagesize("themes/$ThemeSel/images/leftbar.gif");
    $m_size = getimagesize("themes/$ThemeSel/images/mainbar.gif");
    $r_size = getimagesize("themes/$ThemeSel/images/rightbar.gif");
    if ($numip == "") { $numip = 100 ; } # Default 100 per page
    if ($pagenum == "") { $pagenum = 1 ; }
    if ($trackip == 1) {
		$actip = _ACTIVATED;
    } else {
		$actip = _NOTACTIVATED;
    }
    echo "<center><b>"._IPTRACKINGINFO." - $actip"."</center></b><br>";
    echo "<table align=\"center\" bgcolor=\"#000000\" cellspacing=\"1\" cellpadding=\"3\" border=\"0\"><tr>";
	#START allow sorting by any column
	if(is_admin($admin) or (is_user($user) and $members_see_users)) {
		echo "<td bgcolor=\"$bgcolor2\">"._USER;
		echo " (<a href=\"modules.php?name=IP_Tracking&amp;orderby=1&amp;orderdir=asc\">A</a>";
		echo  "\<a href=\"modules.php?name=IP_Tracking&amp;orderby=1&amp;orderdir=desc\">D</a>)</td>";
	}
    echo "<td bgcolor=\"$bgcolor2\">"._IPADDRESS;
	echo " (<a href=\"modules.php?name=IP_Tracking&amp;orderby=2&amp;orderdir=asc\">A</a>";
	echo  "\<a href=\"modules.php?name=IP_Tracking&amp;orderby=2&amp;orderdir=desc\">D</a>)</td>";
	if(is_admin($admin) or !$hide_host or (is_user($user) and $members_see_iphost)) {
		echo "<td bgcolor=\"$bgcolor2\">"._HOSTNAME;
		echo " (<a href=\"modules.php?name=IP_Tracking&amp;orderby=3&amp;orderdir=asc\">A</a>";
		echo  "\<a href=\"modules.php?name=IP_Tracking&amp;orderby=3&amp;orderdir=desc\">D</a>)</td>";
	}
    echo "<td bgcolor=\"$bgcolor2\">"._LASTVIEWED;
	echo " (<a href=\"modules.php?name=IP_Tracking&amp;orderby=4&amp;orderdir=asc\">A</a>";
	echo  "\<a href=\"modules.php?name=IP_Tracking&amp;orderby=4&amp;orderdir=desc\">D</a>)</td>";
    echo "<td bgcolor=\"$bgcolor2\">"._HITS;
	echo " (<a href=\"modules.php?name=IP_Tracking&amp;orderby=5&amp;orderdir=asc\">A</a>";
	echo  "\<a href=\"modules.php?name=IP_Tracking&amp;orderby=5&amp;orderdir=desc\">D</a>)</td></tr>";
	# default values if none set
	if(!$orderby) $orderby="4";
	if(!$orderdir) $orderdir="desc";
	#END allow sorting by any column
	$offset = ($pagenum-1) * $numip ;
	if($show_hits==1) { 
	    $filter="where username is not null";
	} elseif($show_hits==2) { 
	    $filter="where username is null";
	}
	# if multiple Users share same IP Address, then you'll see multiple identical IP Addresses when not displaying User, that's ok.
    $result = sql_query("select username, ip_address, hostname, max(date_time), count(*), min(ipid) from ".$prefix."_iptracking "
	                    ."$filter group by 1,2,3 order by $orderby $orderdir limit $offset, $numip", $dbi);
    while (list($username,$ip,$host,$lastview,$hits,$ipid) = sql_fetch_row($result,$dbi)){
		if(!is_admin($admin) and !(is_user($user) and $members_see_iphost)) $ip = mask_ip($ip);
		echo "<tr bgcolor=\"$bgcolor1\">";
		if(is_admin($admin) or (is_user($user) and $members_see_users)) {
			if($username != ""){
				if($Version_Num >= 6.5) {
					$result2 = sql_query("select user_id from ".$prefix."_users where username='$username'", $dbi);
					list($u) = sql_fetch_row($result2, $dbi);
					if($u != "") {
						echo "<td><a href=\"modules.php?name=Forums&amp;file=profile&amp;mode=viewprofile&amp;u=$u\">$username</a></td>";
					} else {
						echo "<td>$username</td>"; # additional admins aren't in nuke_users so don't make a link
					}
				} else {
					echo "<td><a href=\"modules.php?name=Your_Account&amp;op=userinfo&amp;uname=$username\">$username</a></td>";
				}
			} else { 
				echo "<td> </td>";
			}
		}
		echo "<td><a href=\"modules.php?name=IP_Tracking&amp;op=Pages&amp;ipid=$ipid\">$ip</a></td>";
		if(is_admin($admin) or !$hide_host or (is_user($user) and $members_see_iphost)) echo "<td>$host</td>";
		echo "<td>$lastview</td><td align=\"center\">$hits</td></tr>";
    }
    sql_free_result($result, $dbi);
    echo "</table>";
}

function Pages() {
    global $hlpfile,$nowyear,$nowmonth,$nowdate,$nowhour, $sitename, $startdate, $prefix, $dbi, $now, $ipid, $numip, $pagenum, $Version_Num;
    $result = sql_query("select count from ".$prefix."_counter order by type desc", $dbi);
    list($total) = sql_fetch_row($result, $dbi);
    include ("header.php");
    title("$sitename "._IPTRACKING."");
    OpenTable();
    OpenTable();
    echo "<center><font class=\"option\"><b>$sitename "._IPTRACKING."</b></font><br>";
	echo "<br>"._WERECEIVED." <b>$total</b> "._PAGESVIEWS." $startdate<br>"._TODAYIS.": $now[1]/$now[0]/$now[2]<br><br>";
    echo "</center>";
    CloseTable();
    echo "<br><br>";
    showPageStats();
    echo "<br><br><center>"._GOBACK."</center><br><br>";
    CloseTable();
	$result = sql_query("select ip_address from ".$prefix."_iptracking where ipid=$ipid", $dbi);
    list($ip_address) = sql_fetch_row($result,$dbi);
    $res = sql_query("select * from ".$prefix."_iptracking where ip_address='$ip_address'", $dbi);
    $numurls = sql_num_rows($res, $dbi);
    $numpages = ceil($numurls / $numip);
    if ($numpages > 1) {
		echo "<br>";
		OpenTable();
		echo "<center>";
		echo "$numurls "._URLS." ($numpages "._PAGES.", $numip "._PERPAGE.")<br>" ;
		# START Left Arrow
		if ($pagenum > 1) {
			$prevpage = $pagenum - 1 ;
			if(file_exists("images/download/left.gif")) { 
				$leftarrow = "images/download/left.gif" ;  # 5.x
			} else {
				$leftarrow = "images/left.gif" ;           # 6.x
			}
			echo "<a href=\"modules.php?name=IP_Tracking&amp;op=Pages&amp;ipid=$ipid&amp;pagenum=$prevpage\">";
			echo "<img src=\"$leftarrow\" align=\"absmiddle\" border=\"0\" hspace=\"10\"></a>";
		}
		# END Left Arrow
		# START Page Numbers
		echo "[ " ;
		for ($i=1; $i < $numpages+1; $i++) {
			if ($i == $pagenum) {
				echo "$i";
			} else {
				echo "<a href=\"modules.php?name=IP_Tracking&amp;op=Pages&amp;ipid=$ipid&amp;pagenum=$i\">$i</a>";
			}
			if ($i < $numpages) { echo " | "; } else { echo " ]"; }
		}
		# END Page Numbers
		# START Right Arrow
		if ($pagenum < $numpages) {
			$nextpage = $pagenum + 1 ;
			if(file_exists("images/download/right.gif")) { 
				$rightarrow = "images/download/right.gif" ;  # 5.x
			} else {
				$rightarrow = "images/right.gif" ;           # 6.x
			}
			echo "<a href=\"modules.php?name=IP_Tracking&amp;op=Pages&amp;ipid=$ipid&amp;pagenum=$nextpage\">";
			echo "<img src=\"$rightarrow\" align=\"absmiddle\" border=\"0\" hspace=\"10\"></a>";
		}
		# END Right Arrow
		echo "</center>";
		CloseTable();
	}
	# this is automatic for 6.0+
	if($Version_Num < 6.0) {
		echo "<div align=\"right\"><a href=\"javascript:openwindow()\">IP Tracking &copy;</a></div>";
		echo "<script type=\"text/javascript\">\n";
		echo "<!--\n";
		echo "function openwindow(){\n";
		echo "	window.open (\"modules/IP_Tracking/copyright.php\",\"Copyright\",\"toolbar=no,location=no,directories=no,status=no,scrollbars=yes,resizable=no,copyhistory=no,width=400,height=200\");\n";
		echo "}\n";
		echo "//-->\n";
		echo "</SCRIPT>\n\n";
	}
	include ("footer.php");
}

function showPageStats(){
    global $admin,$prefix,$bgcolor1,$bgcolor2,$dbi, $ThemeSel;
	global $numip, $pagenum, $ipid, $hide_host, $members_see_iphost, $user, $orderby, $orderdir;
    $l_size = getimagesize("themes/$ThemeSel/images/leftbar.gif");
    $m_size = getimagesize("themes/$ThemeSel/images/mainbar.gif");
    $r_size = getimagesize("themes/$ThemeSel/images/rightbar.gif");
    if ($numip == "") { $numip = 100 ; } # Default 100 per page
    if ($pagenum == "") { $pagenum = 1 ; }
	$offset = ($pagenum-1) * $numip ;
	$result = sql_query("select ip_address from ".$prefix."_iptracking where ipid=$ipid", $dbi);
    list($ip_address) = sql_fetch_row($result,$dbi);
	# default values if none set
	if(!$orderby) $orderby="2";
	if(!$orderdir) $orderdir="desc";
    $result = sql_query("select page, date_time from ".$prefix."_iptracking "
	                    ."where ip_address = '$ip_address' "
						."order by $orderby $orderdir limit $offset, $numip ",$dbi);
	echo "<center><b>"._PAGEVIEWINFO."<br>";
	# Admin always see info
	#if(is_admin($admin)) {
	if(!is_admin($admin) and !(is_user($user) and $members_see_iphost)) {
		echo mask_ip($ip_address);
	} else {
		echo "$ip_address";
	}
	#if (is_admin($admin) or !$hide_host) echo " - " . gethostbyaddr($ip_address);
	if(is_admin($admin) or !$hide_host or (is_user($user) and $members_see_iphost)) echo " - " . gethostbyaddr($ip_address);
	echo "</center></b><br>";
    echo "<table align=\"center\" bgcolor=\"#000000\" cellspacing=\"1\" cellpadding=\"3\" border=\"0\"><tr>";
	#START allow sorting by any column
    echo "<td bgcolor=\"$bgcolor2\">"._PAGEVIEWED;
	echo " (<a href=\"modules.php?name=IP_Tracking&amp;op=Pages&amp;ipid=$ipid&amp;orderby=1&amp;orderdir=asc\">A</a>";
	echo  "\<a href=\"modules.php?name=IP_Tracking&amp;op=Pages&amp;ipid=$ipid&amp;orderby=1&amp;orderdir=desc\">D</a>)</td>";
    echo "<td bgcolor=\"$bgcolor2\">"._HITDATE;
	echo " (<a href=\"modules.php?name=IP_Tracking&amp;op=Pages&amp;ipid=$ipid&amp;orderby=2&amp;orderdir=asc\">A</a>";
	echo  "\<a href=\"modules.php?name=IP_Tracking&amp;op=Pages&amp;ipid=$ipid&amp;orderby=2&amp;orderdir=desc\">D</a>)</td></tr>";
	#END allow sorting by any column
    while (list($page,$date_time) = sql_fetch_row($result,$dbi)){
		echo "<tr bgcolor=\"$bgcolor1\"><td><a href=\"$page\">$page</a></td><td>$date_time</td></tr>";
    }
    sql_free_result($result, $dbi);
    echo "</table>";
}

function mask_ip($ip) {
# IP Address Masking
    global $hide_ipseg, $ipmaskchar;
	if(in_array(TRUE, $hide_ipseg)){
		$ipseg = explode(".", $ip);
		for($lcv=1; $lcv<=count($ipseg); $lcv++){
			$seg=$lcv-1;
			# ereg_replace() didn't like $ipseg[$lcv-1] so had to make $seg
			if($hide_ipseg[$lcv]) $ipseg[$seg] = ereg_replace("[0-9]", "$ipmaskchar", "$ipseg[$seg]");
		}
		$ip = implode(".",$ipseg);
	}
	return $ip;
}

switch($op) {

    default:
    IP();
    break;

    case "Pages":
    Pages();
    break;

}

?>
