<?php

#############################################################################################
# IP Tracking Configuration                                                                 #
#                                                                                           #
# Copyright (c) 2003 by Scott Rubin (scottr2@earthlink.net)                                 #
# http://www.ierealtor.com                                                                  #
#                                                                                           #
# $trackip:            Activate IP Tracking?                                (1=Yes 0=No)    #
# $ipmax:              How Many IP Tracking Records Do You Want As A Maximum?               #
# $ipdel:              Delete How Many IP Tracking Records When Maximum Reached?            #
# $numip:              Display How Many IP Tracking Records Per Page?                       #
# $hide_ipseg[1]:      Hide First Segment of the IP Address?                (1=Yes 0=No)    #
# $hide_ipseg[2]:      Hide Second Segment of the IP Address?               (1=Yes 0=No)    #
# $hide_ipseg[3]:      Hide Third Segment of the IP Address?                (1=Yes 0=No)    #
# $hide_ipseg[4]:      Hide Fourth Segment of the IP Address?               (1=Yes 0=No)    #
# $hide_host:          Hide Hostname?                                       (1=Yes 0=No)    #
# $ipmaskchar:         IP Address Masking Character                                         #
# $exclude_ips:        Comma separated list of quoted IP Addresses to exclude               #
# $exclude_hosts:      Comma separated list of quoted Hostnames to exclude                  #
# $members_see_iphost: Ignore Hiding IP segments and Hostnames for Members? (1=Yes 0=No)    #
# $members_see_users:  Let Members see User Names?                          (1=Yes 0=No)    #
# $show_hits:          0=show everyone, 1=only show member hits, 2=only show anonymous hits #
# $offset_hours:       Number of hours offset from Server Time                              #
#                                                                                           #
# Wildcard Characters (*) allowed for $exclude_ips or $exclude_hosts                        #
#                                                                                           #
# NOTE: If you hide IP Address segments but don't hide host,                                #
#       anyone can easily get the IP Address from the host name.                            #
#############################################################################################

#############################################################################################
#
# C O N F I G U R A T I O N   S E C T I O N
#
# NOTE: Admin will always see IP Address / Host information
#
$trackip = 1;
$ipmax = 10000;
$ipdel = 1000;
$numip = 100;
$hide_ipseg[1] = 0;
$hide_ipseg[2] = 0;
$hide_ipseg[3] = 0;
$hide_ipseg[4] = 0;
$hide_host = 0;
$ipmaskchar = "x";
$members_see_iphost = 0;
$members_see_users = 0;
$show_hits = 0;
$offset_hours = 0;

$exclude_ips = array(); # quoted IP comma separated list, wildcards ok
# example: $exclude_ips = array('127.0.0.1', '68.69.+');

$exclude_hosts = array(); # quoted Hostname comma separated list, wildcards ok
# example: $exclude_hosts = array('swbcs007.sbc.com', '.+avantgo.com');

# need regular expression help ???
# try http://www.php.net/manual/en/ref.regex.php for starters
# please don't ask me about regular expressions, here's some popular ones
# n?		Zero or only one single occurrence of character 'n'
# n*		Zero or more occurrences of character 'n'
# n+		At least one or more occurrences of character 'n'
# ^abc 		String starting with the characters 'abc'
# xyz$ 		String ending with the characters 'xyz'
# NOTE: sometimes you really mean + when you write *
# NOTE: for IP beginning 68.12 then use '^68.12'
# NOTE: for IP containing 68.69 then use '68.69'
# NOTE: for IP beginning 68.69. then use '^68.69.+'
#
#############################################################################################

?>
