<?php

##############################################################################
# IP Tracking                                                                #
#                                                                            #
# Copyright (c) 2003 by Scott Rubin (scottr2@earthlink.net)                  #
# http://www.ierealtor.com                                                   #
#                                                                            #
# Insert into the IP Tracking table if $trackip == 1                         #
#                                                                            #
# Delete $ipdel rows from IP Tracking table                                  #
# if number of rows in IP Tracking table reaches $ipmax                      #
#                                                                            #
##############################################################################

global $prefix, $dbi, $trackip, $ipmax, $ipdel, $numip, $ip, $host, $exclude_me;
global $hide_ipseg, $hide_host, $ipmaskchar, $members_see_iphost, $members_see_users, $show_hits, $offset_hours, $cookie, $user, $admin;

require("modules/IP_Tracking/ipconfig.php");

# you can remove these 3 SQL statement if you want after table has been created/modified
@sql_query("create table if not exists ".$prefix."_iptracking (
			 ipid int(10) NOT NULL auto_increment,
			 date_time datetime NOT NULL,
			 ip_address varchar(15) NOT NULL,
			 hostname varchar(100) NOT NULL,
			 page varchar(150) NOT NULL,
			 PRIMARY KEY (ipid),
			 KEY ipid (ipid)
		 )", $dbi);
@sql_query("create index i1iptracking on ".$prefix."_iptracking (ip_address, hostname)", $dbi);
# storing username instead of user_id to avoid joining iptracking table to user table all the time
# luckily username is unique in user table so we can join to it when we want user information
@sql_query("alter table ".$prefix."_iptracking add username varchar(25) after ipid", $dbi);

if ($trackip == 1) {
	# capture User, Timestamp, IP Address, Resolved IP Address, Web Page
	$dt = date("Y-m-d H:i:s", time() + ($offset_hours * 60 * 60)) ;
	$ip = $_SERVER["REMOTE_ADDR"] ;
	$host = gethostbyaddr("$ip");
	if(is_user($user)) {
		cookiedecode($user);
		$username=$cookie[1];
	}
	if(is_admin($admin)) {
		if(!is_array($admin)) {
			$admin = base64_decode($admin);
			$admin = explode(":", $admin);
			$username = "$admin[0]";
		} else {
			$username = "$admin[0]";
		}
	}

	#if (!in_array($ip, $exclude_ips) and (!in_array($host, $exclude_hosts))) {
	$exclude_me=false;
	array_walk($exclude_ips, 'exclude_ip');
	if(!$exclude_me) array_walk($exclude_hosts, 'exclude_host');
	if (!$exclude_me) {
		# concatenate SCRIPT_NAME and QUERY_STRING since REQUEST_URI not used in Windows hosted sites.
		# $pg = getenv(REQUEST_URI);
		# $pg = getenv(SCRIPT_NAME);
		$pg = $_SERVER["SCRIPT_NAME"];
		# if ((getenv(QUERY_STRING)) != "") { $pg = $pg . "?" . getenv(QUERY_STRING) ; }
		if (($_SERVER["QUERY_STRING"]) != "") { $pg = $pg . "?" . $_SERVER["QUERY_STRING"] ; }

		if($username==''){
			# let the database insert a null into the username column
			sql_query("insert into ".$prefix."_iptracking (date_time, ip_address, hostname, page) values('$dt', '$ip', '$host', '$pg')", $dbi);
		} else {
			sql_query("insert into ".$prefix."_iptracking (username, date_time, ip_address, hostname, page) values('$username', '$dt', '$ip', '$host', '$pg')", $dbi);
		}
		# Delete from nuke_iptracking based on parameters set in ipsettings.php
		if ($ipmax > 0 and $ipdel > 0 and $ipmax >= $ipdel) {
			# replaced for speed v3.1.2
			#$tresult = sql_query("select * from ".$prefix."_iptracking", $dbi);
			#$numrows = sql_num_rows($tresult, $dbi);
			$tresult = sql_query("select count(*) from ".$prefix."_iptracking", $dbi);
			list($numrows) = sql_fetch_row($tresult, $dbi);
			if($numrows>=$ipmax) {
				# 'delete ... limit' not ready until mysql 4.0
				# sql_query("delete from ".$prefix."_iptracking order by date_time limit ".$ipdel, $dbi);
				$tresult = sql_query("select date_time from ".$prefix."_iptracking order by date_time limit " .$ipdel.",1", $dbi);
				list($date_time) = sql_fetch_row($tresult, $dbi);
				sql_query("delete from ".$prefix."_iptracking where date_time <= '".$date_time."'", $dbi);
			}   
		}   
	}
}   

function exclude_ip($item) {
# this function checks if the ip address is in the list of ip addresses in the $exclude_ips array
# if it is, set global variable $exclude=true
# wildcard chars are allowed
	global $ip, $exclude_me;
	if(eregi($item, $ip)) $exclude_me=true;
}

function exclude_host($item) {
# this function checks if the hostname is in the list of hostnames in the $exclude_hosts array
# if it is, set global variable $exclude=true
# wildcard chars are allowed
	global $host, $exclude_me;
	if(eregi($item, $host)) $exclude_me=true;
}

?>
