<?php

/*
************************************************************************

 Fichier:			-	speedtest5.inc
 Date:				-	8 Avril 2006
 version			-	5.3
 Modifi par:		- 	Emmanuel Haydont
 Concept Original:	-	Allen Marsalis, Michael L Smith
 
 Description:		-	Test de bande passante IP/ATM en PHP
 
 -> Rtalonnage de testbw()
 -> Les tests sont raliss en tripe et le meilleur rsultat est conserv
 -> Pre-Test avec deux packet de 128Ko (seuls test pour les petits debits < 128Kbps)
 -> Test avec des packets de 128Ko, 512Ko
 -> Extraction du meilleur test de la serie
 -> Conversion et affichage en KB/sec, dbit IP et dbit ATM
 -> Informations de debug ajoute pour une meilleure vauation de l'outil
 
 jusqu'    		-> Test avec
 128 Kbps 			-> 128Ko
 1024 Kbps	 		-> 128Ko + 3 x 128Ko
 4096 et suprieurs -> 128Ko + 3 x 512Ko
 
 Ce programme est sous licence GNU GPL, v2.0 ou ulterieure
 http://www.gnu.org/copyleft/gpl.html
 
 (C) 2005, Emmanuel Haydont
           http://test.haydont.net

************************************************************************
*/

function testbw($koofdata)
{
	$t1=microtime();
	echo "<!--";
	include("./".$koofdata."K.inc");
	echo "-->";
	$t2=microtime();
	$t1=((double)strstr($t1, ' ')+(double)substr($t1,0,strpos($t1,' ')));
	$t2=((double)strstr($t2, ' ')+(double)substr($t2,0,strpos($t2,' ')));
	$kbps = $koofdata*8*1.03/($t2 - $t1);
	return(str_pad(round($kbps, 3),5, "0", STR_PAD_RIGHT));
}

function displayTestResult()
{

	print <<<END
	<TABLE BORDER="0" CELLSPACING="0" CELLPADDING="0">
	<TR>
		<TD HEIGHT="1" BGCOLOR="#000000" colspan="3"></TD>
	</TR>
	<TR>
		<TD WIDTH="1" BGCOLOR="#000000"></TD>
		<TD><table border='0' cellpadding='2' cellspacing='0'>

END;

	// test d'valuation du dbit
	$results = testbw(512);
	$resultsa = $results;
	$resultsb = $results;
	
	// debug: affichage du dbit d'valuation
	// print(" #1 "); print($results); print(" - "); print($resultsa); print(" - "); print($resultsb); print(" - ");
	
	// srie de trois tests pour hauts dbits
	if ($results > 4096) {$results = testbw(512); $resultsa = testbw(512); $resultsb = testbw(512);}
	// srie de trois tests pour moyens dbits
	elseif ($results > 2048) {$results = testbw(128); $resultsa = testbw(128); $resultsb = testbw(128);}
	
	// debug: affichage des dbits finaux
	// print(" #2 "); print($results); print(" - "); print($resultsa); print(" - "); print($resultsb); print(" - ");
		
	// selection des meilleurs rsultats
	if ($results < $resultsa) $results = $resultsa;
	if ($results < $resultsb) $results = $resultsb;
	
	// debug: affichage du dbit selectionn
	// print(" #final "); print($results); print(" . ");
	
	// affichage du tableau
	include("speedtest5.conf");
	$max_value = max($speed_array);
	$kbitPerPixel = $max_value/$max_width;
	$count = count($speed_array);
	for ($i=0; $i<$count; $i++)
	{
		$pixels = ceil($speed_array[$i]/$kbitPerPixel);
		if ($alt_array[$i] == $you_match)
		{
			$image_use = $you_image;
		}
		else
		{
			$image_use = $image;
		}
		$convip = round($speed_array[$i]/8, 2);
		$convatm = round($speed_array[$i]/6.4, 2);
		echo "<tr valign='".$tr_align."' bgcolor='".$tr_bgcolor."'><TD>&nbsp;</td><td align='right'><font face='Arial' size='1' color='#000000'>".$media_array[$i]."</font>&nbsp;</td><td valign='middle'><IMG SRC='".$image_use."' Height='".$bar_height."' width='".$pixels."' alt=\"".$alt_array[$i]." ".$speed_array[$i]." Kbps (".$convip." Ko/sec)\">&nbsp;<B><font face='Arial' size='1' color='#000000'>".$speed_array[$i]."&nbsp;Kbps  (IP: ".$convip." Ko/sec - ATM: ".$convatm." Ko/sec)</font></b></td></tr>\n";
	}
	
	print <<<END

			</table>
		</TD>
		<TD WIDTH="1" BGCOLOR="#000000"></TD>
	</TR>
	<TR><TD HEIGHT="1" BGCOLOR="#000000" colspan="3"></TD></TR>
	<TR><TD HEIGHT="3" BGCOLOR="#FFFFFF" colspan="3"></TD></TR>
	<TR><TD HEIGHT="1" BGCOLOR="#BBBBBB" colspan="3"></TD></TR>
	<TR>
		<TD WIDTH="1" BGCOLOR="#BBBBBB"></TD>
		<TD BGCOLOR="#EEEEEE" align="center"><font face="Arial" size="1" color="#333388"><a href="http://test.haydont.net/speedtest5.php" target="_blank" style="text-decoration: none;"><B>SpeedTest5.PHP (v5.3) </b></a><a href="http://test.haydont.net/sources-v5/" target="_blank" style="text-decoration: none;"><B> E Haydont - Concept Original: A Marsalis, M L Smith - Evolution: G Lacarri&egrave;rele </b></a></font></TD>
		<TD WIDTH="1" BGCOLOR="#BBBBBB"></TD>
	</TR>
	<TR><TD HEIGHT="1" BGCOLOR="#BBBBBB" colspan="3"></TD></TR>
</TABLE>

END;

}

?>
